% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary.R
\name{ECC}
\alias{ECC}
\title{Estimation of errors for common component}
\usage{
ECC(Chat, C0)
}
\arguments{
\item{Chat}{The estimated common component.}

\item{C0}{The true common component.}
}
\value{
A numeric value of the ECC.
}
\description{
Estimation of errors for common component
}
\examples{
\donttest{
dat = gendata()
Y = dat$Y
F0 = dat$F0
L0 = dat$L0
C0 = F0 \%*\% t(L0)
res = REFA(dat$Y, r = 3)
Fhat = res$Fhat
Lhat = res$Lhat
Chat = Fhat \%*\% t(Lhat)
ECC(Chat, C0)
}
}
\references{
Robust factor analysis with exponential squared loss. Jiaqi Hu, Tingyin Wang, Xueqin Wang. Journal of Multivariate Analysis 2026, 213 105567; doi:10.1016/j.jmva.2025.105567
}
\author{
Jiaqi Hu
}
