% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classify_star_spectral_type.R
\name{classify_star_spectral_type}
\alias{classify_star_spectral_type}
\title{Classify spectral type of a star}
\usage{
classify_star_spectral_type(st_teff)
}
\arguments{
\item{st_teff}{Numeric. effective stellar temperature (in K)}
}
\value{
Character. spectral type classification with a letter:
\itemize{
\item \code{M}: 2,500 - 3,500
\item \code{K}: 3,500 - 5,000
\item \code{G}: 5,000 - 6,000
\item \code{F}: 6,000 - 7,500
\item \code{A}: 7,500 - 10,000
\item \code{B}: 10,000 - 28,000
\item \code{O}: 28,000 - 50,000
}
}
\description{
The function takes in effective stellar temperature (in K),
and return letter for the star's spectral type based on Morgan–Keenan (MK) system.
}
\examples{
classify_star_spectral_type(5778)

}
