% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imputer_RNA.R
\name{imputer_RNA}
\alias{imputer_RNA}
\title{Imputation step in stochastic EM for the non-nested RNA Model}
\usage{
imputer_RNA(XX, yy, kernel=kernel, pred1, fits)
}
\arguments{
\item{XX}{A list of design sets for all fidelity levels, containing \code{X_star}, \code{X_list}, and \code{X_tilde}.}

\item{yy}{A list of current observed and pseudo-responses, containing \code{y_star}, \code{y_list}, and \code{y_tilde}.}

\item{kernel}{A character specifying the kernel type to be used. Choices are \code{"sqex"}(squared exponential), \code{"matern1.5"}, or \code{"matern2.5"}.}

\item{pred1}{Predictive results for the lowest fidelity level \eqn{f_1}. It should include \code{cov} obtained by setting \code{cov.out=TRUE}.}

\item{fits}{A fitted GP object from \code{RNAmf}.}
}
\value{
An updated \code{yy} list containing:
\itemize{
  \item \code{y_star}: An updated pseudo-complete outputs \eqn{\mathbf{y}^*_l}.
  \item \code{y_list}: An original outputs \eqn{\mathbf{y}_l}.
  \item \code{y_tilde}: A newly imputed pseudo outputs \eqn{\widetilde{\mathbf{y}}_l}.
}
}
\description{
The function performs the imputation step of the stochastic EM algorithm for the RNA model when the design is not nested.
The function generates pseudo outputs \eqn{\widetilde{\mathbf{y}}_l} at pseudo inputs \eqn{\widetilde{\mathcal{X}}_l}.
}
\details{
The \code{imputer_RNA} function then imputes the corresponding pseudo outputs
\eqn{\widetilde{\mathbf{y}}_l = f_l(\widetilde{\mathcal{X}}_l)}
by drawing samples from the conditional normal distribution,
given fixed parameter estimates and previous-level outputs \eqn{Y_{l}^{*(m-1)}} for each \eqn{l},
at the \eqn{m}-th iteration of the EM algorithm.
}
