% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantiles.RSDA.KS.r
\name{quantiles.RSDA.KS}
\alias{quantiles.RSDA.KS}
\title{quantiles.RSDA.KS}
\usage{
quantiles.RSDA.KS(histogram.matrix, num.quantiles)
}
\arguments{
\item{histogram.matrix}{A matrix of histograms}

\item{num.quantiles}{Number of quantiles}
}
\value{
Quantiles of a Histogram Matrix
}
\description{
quantiles.RSDA.KS
}
\examples{
\dontrun{
data("hardwoodBrito")
Hardwood.histogram<-hardwoodBrito
Hardwood.cols<-colnames(Hardwood.histogram)
Hardwood.names<-row.names(Hardwood.histogram)
 M<-length(Hardwood.cols)
 N<-length(Hardwood.names)
 BIN.Matrix<-matrix(rep(3,N*M),nrow = N)
pca.hist<-sym.histogram.pca(Hardwood.histogram,BIN.Matrix)
quantiles.RSDA.KS<-quantiles.RSDA(pca.hist$sym.hist.matrix.PCA,100)
}
}
\author{
Jorge Arce Garro
}
