% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00roxygen.R, R/chol.R, R/determinant.R,
%   R/eigen.R, R/methods.R
\name{ADmatrix}
\alias{ADmatrix}
\alias{chol.advector}
\alias{determinant.advector}
\alias{eigen,adcomplex-method}
\alias{eigen,advector-method}
\alias{svd,advector-method}
\alias{t.adsparse}
\alias{[.adsparse}
\alias{[<-.adsparse}
\alias{as.matrix.adsparse}
\alias{diag,adsparse,missing,missing-method}
\alias{band,adsparse-method}
\alias{tril,adsparse-method}
\alias{triu,adsparse-method}
\alias{expm,advector-method}
\alias{expm,adsparse-method}
\alias{dim,adsparse-method}
\alias{\%*\%,anysparse,ad-method}
\alias{\%*\%,ad,anysparse-method}
\alias{\%*\%,adsparse,adsparse-method}
\alias{\%*\%,ad,ad-method}
\alias{tcrossprod,ad,ad.-method}
\alias{crossprod,ad,ad.-method}
\alias{cov2cor,advector-method}
\alias{solve,ad,ad.-method}
\alias{solve,num,num.-method}
\alias{solve,anysparse,ad.-method}
\alias{colSums,advector-method}
\alias{rowSums,advector-method}
\alias{colSums,adsparse-method}
\alias{rowSums,adsparse-method}
\alias{cbind.advector}
\alias{rbind.advector}
\alias{Math,adsparse-method}
\title{AD matrix methods (sparse and dense)}
\usage{
\method{chol}{advector}(x, ...)

\method{determinant}{advector}(x, logarithm = TRUE, ...)

\S4method{eigen}{adcomplex}(x, symmetric, only.values = FALSE, EISPACK = FALSE)

\S4method{eigen}{advector}(x, symmetric, only.values = FALSE, EISPACK = FALSE)

\S4method{svd}{advector}(x, nu, nv, LINPACK = FALSE)

\method{t}{adsparse}(x)

\method{[}{adsparse}(x, ...)

\method{[}{adsparse}(x, ...) <- value

\method{as.matrix}{adsparse}(x, ...)

\S4method{diag}{adsparse,missing,missing}(x)

\S4method{band}{adsparse}(x, k1, k2)

\S4method{tril}{adsparse}(x, k)

\S4method{triu}{adsparse}(x, k)

\S4method{expm}{advector}(x)

\S4method{expm}{adsparse}(x)

\S4method{dim}{adsparse}(x)

\S4method{\%*\%}{anysparse,ad}(x, y)

\S4method{\%*\%}{ad,anysparse}(x, y)

\S4method{\%*\%}{adsparse,adsparse}(x, y)

\S4method{\%*\%}{ad,ad}(x, y)

\S4method{tcrossprod}{ad,ad.}(x, y)

\S4method{crossprod}{ad,ad.}(x, y)

\S4method{cov2cor}{advector}(V)

\S4method{solve}{ad,ad.}(a, b)

\S4method{solve}{num,num.}(a, b)

\S4method{solve}{anysparse,ad.}(a, b)

\S4method{colSums}{advector}(x, na.rm, dims)

\S4method{rowSums}{advector}(x, na.rm, dims)

\S4method{colSums}{adsparse}(x, na.rm, dims)

\S4method{rowSums}{adsparse}(x, na.rm, dims)

\method{cbind}{advector}(...)

\method{rbind}{advector}(...)

\S4method{Math}{adsparse}(x)
}
\arguments{
\item{x}{matrix (sparse or dense)}

\item{...}{As \link[base]{cbind}}

\item{logarithm}{Not used}

\item{symmetric}{Logical; Is input matrix symmetric (Hermitian) ?}

\item{only.values}{Ignored}

\item{EISPACK}{Ignored}

\item{nu}{Ignored}

\item{nv}{Ignored}

\item{LINPACK}{Ignored}

\item{value}{Replacement value}

\item{k1}{See Matrix package}

\item{k2}{See Matrix package}

\item{k}{See Matrix package}

\item{y}{matrix (sparse or dense)}

\item{V}{Covariance matrix}

\item{a}{matrix}

\item{b}{matrix, vector or missing}

\item{na.rm}{Logical; Remove NAs while taping.}

\item{dims}{Same as \link[base]{colSums} and \link[base]{rowSums}.}
}
\value{
List (vectors/values) with \code{adcomplex} components.

List (vectors/values) with \code{advector} components in symmetric case and \code{adcomplex} components otherwise.

Object of class \code{advector} with a dimension attribute for dense matrix operations; Object of class \code{adsparse} for sparse matrix operations.
}
\description{
Matrices (\strong{base} package) and sparse matrices (\strong{Matrix} package) can be used inside the \code{RTMB} objective function as part of the calculations. Behind the scenes these R objects are converted to AD representations when needed. AD objects have a temporary lifetime, so you probably won't see them / need to know them. The only important thing is which \emph{methods} work for the objects.
}
\section{Functions}{
\itemize{
\item \code{chol(advector)}: AD matrix cholesky

\item \code{determinant(advector)}: AD log determinant

\item \code{eigen(adcomplex)}: General AD eigen decomposition for complex matrices. Note that argument \code{symmetric} is \strong{not} auto-detected so \strong{must} be specified.

\item \code{eigen(advector)}: AD eigen decomposition for real matrices. The non-symmetric case is redirected to the \code{adcomplex} method. Note that argument \code{symmetric} is \strong{not} auto-detected so \strong{must} be specified.

\item \code{svd(advector)}: AD svd decomposition for real matrices.

\item \code{t(adsparse)}: AD sparse matrix transpose. Re-directs to \link[Matrix]{t,CsparseMatrix-method}.

\item \code{[}: AD sparse matrix subsetting. Re-directs to \link[Matrix]{[-methods}.

\item \code{`[`(adsparse) <- value}: AD sparse matrix subset assignment. Re-directs to \link[Matrix]{[<--methods}.

\item \code{as.matrix(adsparse)}: Convert AD sparse to dense matrix.

\item \code{diag(x = adsparse, nrow = missing, ncol = missing)}: AD sparse matrix diagonal extract. Re-directs to \link[Matrix]{diag,CsparseMatrix-method}.

\item \code{band(adsparse)}: AD sparse matrix band extract. Re-directs to \link[Matrix]{band,CsparseMatrix-method}.

\item \code{tril(adsparse)}: AD sparse matrix lower triangle extract. Re-directs to \link[Matrix]{tril,CsparseMatrix-method}.

\item \code{triu(adsparse)}: AD sparse matrix upper triangle extract. Re-directs to \link[Matrix]{triu,CsparseMatrix-method}.

\item \code{expm(advector)}: AD matrix exponential

\item \code{expm(adsparse)}: AD matrix exponential

\item \code{dim(adsparse)}: AD sparse matrix dimension

\item \code{x \%*\% y}: AD matrix multiply

\item \code{x \%*\% y}: AD matrix multiply

\item \code{x \%*\% y}: AD matrix multiply

\item \code{x \%*\% y}: AD matrix multiply

\item \code{tcrossprod(x = ad, y = ad.)}: AD matrix multiply

\item \code{crossprod(x = ad, y = ad.)}: AD matrix multiply

\item \code{cov2cor(advector)}: AD matrix cov2cor

\item \code{solve(a = ad, b = ad.)}: AD matrix inversion and solve

\item \code{solve(a = num, b = num.)}: AD matrix inversion and solve

\item \code{solve(a = anysparse, b = ad.)}: Sparse AD matrix solve

\item \code{colSums(advector)}: AD matrix (or array) colsums

\item \code{rowSums(advector)}: AD matrix (or array) rowsums

\item \code{colSums(adsparse)}: AD sparse matrix colsums

\item \code{rowSums(adsparse)}: AD sparse matrix rowsums

\item \code{cbind(advector)}: AD matrix column bind

\item \code{rbind(advector)}: AD matrix row bind

\item \code{Math(adsparse)}: AD sparse matrix 'Math group' works for functions that preserve sparsity.

}}
\examples{
F <- MakeTape(function(x) matrix(1:9,3,3) \%*\% x, numeric(3))
F$jacobian(1:3)
F <- MakeTape(function(x) Matrix::expm(matrix(x,2,2)), numeric(4))
F$jacobian(1:4)
F <- MakeTape(det, diag(2)) ## Indirectly available via 'determinant'
F$jacobian(matrix(1:4,2))
}
