% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_ENET.R
\name{do.enet}
\alias{do.enet}
\title{Elastic Net Regularization}
\usage{
do.enet(X, response, ndim = 2, lambda1 = 1, lambda2 = 1)
}
\arguments{
\item{X}{an \eqn{(n\times p)} matrix or data frame whose rows are observations
and columns represent independent variables.}

\item{response}{a length-\eqn{n} vector of response variable.}

\item{ndim}{an integer-valued target dimension.}

\item{lambda1}{\eqn{\ell_1} regularization parameter in \eqn{(0,\infty)}.}

\item{lambda2}{\eqn{\ell_2} regularization parameter in \eqn{(0,\infty)}.}
}
\value{
a named \code{Rdimtools} S3 object containing
\describe{
\item{Y}{an \eqn{(n\times ndim)} matrix whose rows are embedded observations.}
\item{featidx}{a length-\eqn{ndim} vector of indices with highest scores.}
\item{projection}{a \eqn{(p\times ndim)} whose columns are basis for projection.}
\item{algorithm}{name of the algorithm.}
}
}
\description{
Elastic Net is a regularized regression method by solving
\deqn{\textrm{min}_{\beta} ~ \frac{1}{2}\|X\beta-y\|_2^2 + \lambda_1 \|\beta \|_1 + \lambda_2 \|\beta \|_2^2}
where \eqn{y} iis \code{response} variable in our method. The method can be used in feature selection like LASSO.
}
\examples{
\donttest{
## generate swiss roll with auxiliary dimensions
## it follows reference example from LSIR paper.
set.seed(100)
n = 123
theta = runif(n)
h     = runif(n)
t     = (1+2*theta)*(3*pi/2)
X     = array(0,c(n,10))
X[,1] = t*cos(t)
X[,2] = 21*h
X[,3] = t*sin(t)
X[,4:10] = matrix(runif(7*n), nrow=n)

## corresponding response vector
y = sin(5*pi*theta)+(runif(n)*sqrt(0.1))

## try different regularization parameters
out1 = do.enet(X, y, lambda1=0.01)
out2 = do.enet(X, y, lambda1=1)
out3 = do.enet(X, y, lambda1=100)

## extract embeddings
Y1 = out1$Y; Y2 = out2$Y; Y3 = out3$Y

## visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,3))
plot(Y1, pch=19, main="ENET::lambda1=0.01")
plot(Y2, pch=19, main="ENET::lambda1=1")
plot(Y3, pch=19, main="ENET::lambda1=100")
par(opar)
}

}
\references{
\insertRef{zou_regularization_2005}{Rdimtools}
}
\author{
Kisung You
}
\concept{feature_methods}
