% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RealSurvSim.R
\name{RealSurvSim}
\alias{RealSurvSim}
\title{Simulate Datasets Using Various Simulation Models}
\usage{
RealSurvSim(
  dat,
  col_time,
  col_status,
  col_group,
  reps = 10000,
  random_seed = 123,
  n = NULL,
  simul_type = c("cond", "case", "distr", "KDE"),
  distribs = c("exp", "exp", "exp", "exp")
)
}
\arguments{
\item{dat}{A data.frame representing the original or reconstructed dataset for simulation.
The dataset must include three columns: for event times, for censoring status,
and for group identifiers.}

\item{col_time}{The name or index of the column in \code{dat} representing time to event.}

\item{col_status}{The name or index of the column in \code{dat} representing the event status
(1 for event occurred, 0 for censored).}

\item{col_group}{The name or index of the column in \code{dat} representing group assignments.}

\item{reps}{The number of iterations, equivalent to the number of datasets simulated for each simulation model.
Defaults to 10000.}

\item{random_seed}{Seed for random number generation to ensure reproducibility. Defaults to 123.}

\item{n}{An optional numeric vector specifying the number of observations to simulate for each group.
If \code{NULL}, the function uses the original dataset's group sizes for simulation.
For all simulation types except "conditional bootstrap," \code{n} can be set to arbitrary values,
such as \code{c(50, 60)}, where each element specifies the number of observations for a group.
Defaults to \code{NULL}.}

\item{simul_type}{A vector of characters specifying the types of simulation to perform. It includes
"cond" (conditional bootstrap), "case" (case resampling), "distr" (parametric distributions),
and "KDE" (kernel density estimation, supports all kernels available in the \code{kdensity} function. Refer to 'kdensity'). Note: Only one simulation type can be used at a time.}

\item{distribs}{Character vector of length 4, one distribution per stratum.
Must be one of:
\itemize{
\item \code{"inverse_gamma"}
\item \code{"llogis"}
\item \code{"gumbel"}
\item \code{"exp"}
\item \code{"gamma"}
\item \code{"normal"}
\item \code{"cauchy"}
}

Defaults to \code{c("exp", "exp", "exp", "exp")}.}
}
\value{
A list containing the simulated datasets for each specified simulation model.
The structure of the output list is as follows:

\if{html}{\out{<div class="sourceCode">}}\preformatted{     - \{datasets\}: A list of data frames, where each data frame represents a simulated dataset.
     - Each data frame contains:
         - \{V1\}: A numeric vector representing the simulated time-to-event data.
         - \{V2\}: A numeric or integer vector indicating the status, representing
           whether the event of interest has occurred (1) or is censored (0).
         - \{V3\}: An integer vector representing group.

     - The number of data frames within \{datasets\} corresponds to the number of repetitions specified
       by the \{reps\} parameter.
}\if{html}{\out{</div>}}
}
\description{
Simulates survival datasets(Time-to-event data) based on original or reconstructed data using four different simulation models:
Kernel Density Estimation (KDE), parametric distributions, conditional bootstrap, and Case Resampling.
This function is designed to support comprehensive survival analysis simulations.
}
\examples{
# liang should have columns: V1 (time), V2 (status), V3 (group)

         # Simulate data using parametric distribution fitting

          liang<- dats$Liang
          liang_distr <- RealSurvSim(
           dat = liang,
           col_time = "V1",
           col_status = "V2",
           col_group = "V3",
           reps = 10,
           simul_type = "distr",
           distribs = c("exp", "exp", "exp", "exp")
         )



}
