% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RealSurvSim.R
\name{data_simul_KDE}
\alias{data_simul_KDE}
\title{Kernel Density Estimation-based Data Simulation}
\usage{
data_simul_KDE(orig_vals, n = NULL, kernel = "gaussian")
}
\arguments{
\item{orig_vals}{Numeric vector of values from the original dataset.}

\item{n}{Integer, number of observations to simulate. If \code{NULL}, the function
simulates the same number of observations as in the original dataset. Defaults to \code{NULL}.}

\item{kernel}{Character, specifying the kernel to be used for KDE. Defaults to "gaussian".}
}
\value{
Numeric vector of \code{n} simulated values.
}
\description{
Simulates data based on the kernel density estimation (KDE) of given data.
KDE is a non-parametric way to estimate the probability density function of a random variable.
This function applies the accept-reject method to generate values that follow
the estimated density of the original dataset.
}
\examples{
original_data <- c(rnorm(100, mean = 50, sd = 10))
simulated_data <- data_simul_KDE(original_data, n = 100)
}
