% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RegEnRF.R
\name{RegEnRF}
\alias{RegEnRF}
\title{Regression-Enhanced Random Forests}
\usage{
RegEnRF(x, y, lambda, ...)
}
\arguments{
\item{x}{A numeric matrix of predictors. Requirement: nvars >1;
in other words, x should have 2 or more columns. This is a constraint
of \code{\link[glmnet:glmnet]{glmnet::glmnet()}}.}

\item{y}{A numeric response vector.}

\item{lambda}{See 'lambda' argument in \code{\link[glmnet:glmnet]{glmnet::glmnet()}}.}

\item{...}{other arguments passed to \code{\link[glmnet:glmnet]{glmnet::glmnet()}} and
\code{\link[randomForest:randomForest]{randomForest::randomForest()}}.}
}
\value{
An object with S3 class "RegEnRF"
}
\description{
\code{RegEnRF()} implements Regression-Enhanced Random Forests algorithm (based on
Zhang et al., 2019 paper) for regression.
}
\details{
This function is based on the packages \code{randomForest::randomForest}
and \code{glmnet::glmnet}.
}
\examples{
set.seed(111)
data(co2)
x <- matrix(c(time(co2), cycle(co2)), ncol = 2)
y <- as.numeric(co2)
mod <- RegEnRF(x, y, lambda = 0.1)
freq <- frequency(co2)
startt <- tsp(co2)[2] + 1 / freq
xnew.t <- seq(startt, by = 1 / freq, length.out = freq * 3)
xnew <- matrix(c(xnew.t, cycle(tail(co2, freq * 3))), ncol = 2)
pred <- predict(mod, xnew)
pred.ts <- ts(pred, start = startt, frequency = freq)
plot(ts.union(co2, pred.ts), plot.type = "single", col = c("black", "red"))
}
\references{
Zhang, H., Nettleton, D., & Zhu, Z. (2019). Regression-enhanced
random forests. arXiv preprint
\doi{10.48550/arXiv.1904.10416}.
}
\author{
Umberto Minora \email{umbertofilippo@tiscali.it}, based on the paper
by Zhang et al. (2019).
}
