% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_advanced.R
\name{kernel_cpd_detect}
\alias{kernel_cpd_detect}
\title{Kernel-based Changepoint Detection}
\usage{
kernel_cpd_detect(
  data,
  penalty = "bic",
  kernel = "rbf",
  bandwidth = 0,
  min_segment = 5
)
}
\arguments{
\item{data}{Numeric vector or matrix (rows = observations)}

\item{penalty}{Penalty for changepoints (default: "bic")}

\item{kernel}{Kernel function to use:
\itemize{
\item \code{"rbf"}: Radial Basis Function (Gaussian) kernel
\item \code{"linear"}: Linear kernel
\item \code{"poly"}: Polynomial kernel
\item \code{"laplacian"}: Laplacian kernel
}}

\item{bandwidth}{Kernel bandwidth (0 = automatic median heuristic)}

\item{min_segment}{Minimum segment length}
}
\value{
List with changepoints and kernel statistics
}
\description{
Detects changepoints using Maximum Mean Discrepancy (MMD) in a
Reproducing Kernel Hilbert Space. This nonparametric approach can
detect changes in any aspect of the distribution.
}
\references{
Arlot, S., Celisse, A., and Harchaoui, Z. (2019). A kernel multiple
change-point algorithm via model selection. Journal of Machine
Learning Research, 20(162), 1-56.
}
