% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichment.R
\name{KO_safe}
\alias{KO_safe}
\title{Perform Significance Analysis of Function and Expression}
\usage{
KO_safe(
  reporter_res,
  verbose = TRUE,
  perm = 1000,
  C.matrix = NULL,
  p.adjust.method = "BH",
  ...
)
}
\arguments{
\item{reporter_res}{The input reporter result.}

\item{verbose}{If TRUE, print verbose messages. Default is TRUE.}

\item{perm}{The number of permutations. Default is 1000.}

\item{C.matrix}{The contrast matrix. Default is NULL, and it will be generated from the module list.}

\item{p.adjust.method}{Method for p-value adjustment. Default is "BH".}

\item{...}{Additional parameters to be passed to \code{\link[safe]{safe}} function.}
}
\value{
A data frame containing SAFE results for KO enrichment.
}
\description{
Perform Significance Analysis of Function and Expression
}
\seealso{
Other common_enrich: 
\code{\link{KO_enrich}()},
\code{\link{KO_fisher}()},
\code{\link{KO_gsa}()},
\code{\link{KO_gsea}()},
\code{\link{KO_gsva}()},
\code{\link{KO_padog}()},
\code{\link{KO_sea}()},
\code{\link{plot_enrich_res}()}
}
\concept{common_enrich}
