% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial_prediction.R
\name{update_predictors}
\alias{update_predictors}
\title{Update Predictors for a RiskMap Prediction Object}
\usage{
update_predictors(object, predictors)
}
\arguments{
\item{object}{A `RiskMap.pred.re` object, which is the output of the \code{\link{pred_over_grid}} function.}

\item{predictors}{A data frame containing the new predictor values. The number of rows must match the prediction grid in the `object`.}
}
\value{
The updated `RiskMap.pred.re` object.
}
\description{
This function updates the predictors of a given RiskMap prediction object. It ensures that the new predictors match the original prediction grid and updates the relevant components of the object accordingly.
}
\details{
The function performs several checks and updates:
\itemize{
  \item Ensures that `object` is of class `RiskMap.pred.re`.
  \item Ensures that the number of rows in `predictors` matches the prediction grid in `object`.
  \item Removes any rows with missing values in `predictors` and updates the corresponding components of the `object`.
  \item Updates the prediction locations, the predictive samples for the random effects, and the linear predictor.
}
}
\author{
Emanuele Giorgi \email{e.giorgi@lancaster.ac.uk}

Claudio Fronterre \email{c.fronterr@lancaster.ac.uk}
}
