% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{weighted_normal}
\alias{weighted_normal}
\alias{dwnorm}
\alias{pwnorm}
\alias{qwnorm}
\alias{rwnorm}
\title{Weighted normal distribution}
\usage{
dwnorm(
  x,
  mean,
  sd,
  steps = if (!is.null(crit_x)) NULL,
  omega,
  crit_x = if (!is.null(steps)) NULL,
  type = "two.sided",
  log = FALSE
)

pwnorm(
  q,
  mean,
  sd,
  steps = if (!is.null(crit_x)) NULL,
  omega,
  crit_x = if (!is.null(steps)) NULL,
  type = "two.sided",
  lower.tail = TRUE,
  log.p = FALSE
)

qwnorm(
  p,
  mean,
  sd,
  steps = if (!is.null(crit_x)) NULL,
  omega,
  crit_x = if (!is.null(steps)) NULL,
  type = "two.sided",
  lower.tail = TRUE,
  log.p = FALSE
)

rwnorm(
  n,
  mean,
  sd,
  steps = if (!is.null(crit_x)) NULL,
  omega,
  crit_x = if (!is.null(steps)) NULL,
  type = "two.sided"
)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{mean}{mean}

\item{sd}{standard deviation.}

\item{steps}{vector of steps for the weight function.}

\item{omega}{vector of weights defining the probability
of observing a t-statistics between each of the two steps.}

\item{crit_x}{vector of critical values defining steps
(if \code{steps} are not supplied).}

\item{type}{type of weight function (defaults to \code{"two.sided"}).}

\item{log, log.p}{logical; if \code{TRUE}, probabilities
\code{p} are given as \code{log(p)}.}

\item{lower.tail}{logical; if \code{TRUE} (default), probabilities
are \eqn{P[X \le x]}, otherwise, \eqn{P[X \ge x]}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If length(n) > 1, the length
is taken to be the number required.}
}
\value{
\code{dwnorm} gives the density, \code{dwnorm} gives the
distribution function, \code{qwnorm} gives the quantile function,
and \code{rwnorm} generates random deviates.
}
\description{
Density, distribution function, quantile function
and random generation for the weighted normal distribution with
\code{mean}, standard deviation \code{sd}, steps \code{steps}
(or critical values) \code{crit_x}), and weights \code{omega}.
}
\details{
The \code{mean}, \code{sd}, \code{steps}, \code{omega} can be
supplied as a vectors (\code{mean}, \code{sd}) or matrices (\code{steps},
\code{omega}) with length / number of rows equal to \code{x}/\code{q}/
\code{p}. Otherwise, they are recycled to the length of the result.
}
\examples{
# generate random samples from weighted normal distribution
samples <- rwnorm(n = 10000, mean = 0.15, sd = 0.10,
                  steps = c(0.025, 0.5), omega = c(0.1, 0.5, 1),
                  type = "one.sided")
# hist(samples)

# compute density at specific values
density_vals <- dwnorm(x = c(-2, 0, 2), mean = 0, sd = 1,
                       steps = c(0.05), omega = c(0.5, 1))

# compute cumulative probabilities
prob_vals <- pwnorm(q = c(-1, 0, 1), mean = 0, sd = 1,
                    steps = c(0.05), omega = c(0.5, 1))
}
\seealso{
\link[stats]{Normal}
}
