% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{h_first_fct_nested_in_second}
\alias{h_first_fct_nested_in_second}
\title{Check Whether First Factor is Nested in Second Factor}
\usage{
h_first_fct_nested_in_second(f1, f2)
}
\arguments{
\item{f1}{A factor variable, supposed to be more fine grained than \code{f2}.}

\item{f2}{A factor variable, supposed to be more coarse grained than \code{f1}.}
}
\value{
\code{TRUE} if \code{f1} is nested in \code{f2}, \code{FALSE} otherwise.
}
\description{
This function checks whether one factor variable is nested in another in terms of their levels
and the mapping of observations to these levels:
}
\details{
\itemize{
\item Both factors must have the same length.
\item The positions of \code{NA} values must be identical in both factors.
\item After removing \code{NA} values, \code{f1} must have at least as many observed levels as \code{f2}.
\item The mapping of observations to levels must be consistent, meaning that each level in \code{f1}
corresponds to exactly one level in \code{f2}. On the other hand, multiple levels in \code{f1}
can map to the same level in \code{f2}.
}
}
\keyword{internal}
