% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/showImgMask.R
\name{showImgMask}
\alias{showImgMask}
\alias{applyImgMask}
\title{Depict images with masking layers}
\usage{
showImgMask(root_img = NULL, mask = NULL, mask_col = "grey")

applyImgMask(root_img = NULL, mask = NULL, mask_col = "grey")
}
\arguments{
\item{root_img}{Root image. Can be a PNG, i.e., an array with 3 dimensions
(3 layers each containing a 2-dim. numeric matrix with values between
0 and 1), or a 2-dim. matrix. If the root image is NULL (default), then a
completely black image is used.}

\item{mask}{2-dim. true/false-matrix with the same number of rows and columns
as \code{skel_img} (optional, default = NULL, interpreted as a matrix
consisting only of TRUEs, i.e., nothing is "removed" from the image).}

\item{mask_col}{Color of the FALSE-regions of the mask (default "grey").
Can be of any of the three kinds of R color specifications, i.e., either a
color name (as listed by colors()), a hexadecimal string (see Details), or a
positive integer (indicates using palette()).}
}
\value{
\code{showImgMask} No return value, called for side effects
(plotting).

\code{applyImgMask} An array with 3 dimensions
(3 layers each containing a 2-dim. numeric matrix with values between
0 and 1) like a PNG.
}
\description{
\code{showImgMask} - Depicts an image, e.g., a root scan, with an optional
masking layer using a specified color.

\code{applyImgMask} - Changes the colouring of an image, e.g., a root scan,
according to a masking layer using a specified color. If only a matrix is
provided, it is treated like the r-layer (referring to the rgb color values).
}
\examples{
# Basic example:
showImgMask(matrix(c(1,0,0,0,
                     0,1,0,0,
                     0,0,1,1), ncol = 4, nrow = 3, byrow = TRUE),
             matrix(c(TRUE, FALSE,FALSE,TRUE,
                      TRUE, TRUE, TRUE, TRUE,
                      FALSE,TRUE, TRUE, FALSE), ncol = 4, nrow = 3,
                      byrow = TRUE))
# Example using the createDepthLayerMasks()-function:.
showImgMask(root_img = matrix(c(1,0,0,0,0,0,0,
                      0,1,0,0,0,0,0,
                      0,0,1,1,0,0,0), ncol = 7, nrow = 3, byrow = TRUE),
             mask = createDepthLayerMasks(ppcm = 1,
                          dims_px = c(3,7),
                          depth_levels_cm = rbind(c(-1,-2), c(-2,-3)))[[1]],
             mask_col ="brown")
# Basic example:
applyImgMask(matrix(c(1,0,0,0,
                     0,1,0,0,
                     0,0,1,1), ncol = 4, nrow = 3, byrow = TRUE),
             matrix(c(TRUE, FALSE,FALSE,TRUE,
                      TRUE, TRUE, TRUE, TRUE,
                      FALSE,TRUE, TRUE, FALSE), ncol = 4, nrow = 3,
                      byrow = TRUE))
}
