% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_range_plot.R
\name{create_range_plot}
\alias{create_range_plot}
\title{create_range_plot}
\usage{
create_range_plot(
  df = NULL,
  orientation = "vertical",
  factor_var = NULL,
  min_meas = NULL,
  max_meas = NULL,
  labels = NULL,
  labels_meas = NULL,
  labels_fill = "red",
  labels_hjust = -0.4,
  labels_vjust = 1.4,
  title = NULL,
  subtitle = NULL,
  caption = NULL,
  center_titles = FALSE,
  factor_title = NULL,
  meas_title = NULL,
  hide_x_tics = FALSE,
  hide_y_tics = FALSE,
  rot_x_tic_angle = 0,
  rot_y_tic_label = FALSE,
  meas_limits = NULL,
  meas_major_breaks = waiver(),
  meas_minor_breaks = waiver(),
  meas_labels = waiver(),
  meas_log10 = FALSE,
  meas_padding = c(0.02, 0.02),
  axis_text_size = 11,
  pts_shape = 21,
  pts_stroke = 1,
  pts_stroke_color = "black",
  pts_size = 2,
  pts_fill = c("green", "red"),
  line_type = "solid",
  line_width = 1,
  line_pts_alpha = 1,
  panel_color = "white",
  panel_border_color = "black",
  show_major_grids = TRUE,
  show_minor_grids = TRUE,
  silent_NA_warning = FALSE,
  png_file_path = NULL,
  png_width_height = c(480, 480)
)
}
\arguments{
\item{df}{The target data frame from which the point ranges are plotted.}

\item{orientation}{A string that sets the orientation/direction of the segments.
Acceptable values are either "vertical" (the default) or "horizontal".}

\item{factor_var}{A required variable name from 'df' that sets the factor/discreet variable for segment positioning.}

\item{min_meas}{A required variable name from 'df' that defines the minimum values for each segment.}

\item{max_meas}{A required variable name from 'df' that defines the maximum values for each segment.}

\item{labels}{A character variable from 'df' that defines the actual label for each segment.}

\item{labels_meas}{An optional variable name from 'df' that sets the value for a labelled point on each segment.}

\item{labels_fill}{A string that sets the fill color of the labelled point on the segments.}

\item{labels_hjust}{A numeric that adjust the 'labels' in the horizontal direction.}

\item{labels_vjust}{A numeric that adjust the 'labels' in the vertical direction.}

\item{title}{A string that sets the plot title.}

\item{subtitle}{A string that sets the plot subtitle.}

\item{caption}{A string that sets the plot caption}

\item{center_titles}{A logical which if \code{TRUE} centers both the 'title'
and 'subtitle'.}

\item{factor_title}{A string that sets the axis title the factor.}

\item{meas_title}{A string that sets the axis title for the measures.}

\item{hide_x_tics}{A logical that controls the appearance of the x axis tics.}

\item{hide_y_tics}{A logical that controls the appearance of the y axis tics.}

\item{rot_x_tic_angle}{A numeric that sets the angle of rotation for the x tic labels.
When factor tic labels are long, a value of 40 for this argument usually works well.}

\item{rot_y_tic_label}{A logical which if TRUE rotates the y tic labels 90 degrees
for enhanced readability.}

\item{meas_limits}{A numeric 2 element vector that sets the minimum and maximum for the measure axis.}

\item{meas_major_breaks}{A numeric vector or function that defines the exact major tic locations along the measure axis.}

\item{meas_minor_breaks}{A numeric vector or function that defines the exact minor tic locations along the measure axis.}

\item{meas_labels}{A character vector with the same length as 'meas_major_breaks', that labels the major tics.}

\item{meas_log10}{A logical which if \code{TRUE} will use a log10 scale for the measure axis.}

\item{meas_padding}{A numeric 2 element vector that pads the measure axis scale.}

\item{axis_text_size}{A numeric that sets the font size along the axis'. Default is 11.}

\item{pts_shape}{A numeric integer that sets the shape of the points. Typical values are 21 "circle",
22 "square", 23 "diamond", 24 "up triangle", 25 "down triangle".}

\item{pts_stroke}{A numeric that sets the outline width for a point shape.}

\item{pts_stroke_color}{A string that sets the point's outline color.}

\item{pts_size}{A numeric that sets the point size.}

\item{pts_fill}{A string vector that sets the colors of the lower and upper points.
The default is c("green", "red").}

\item{line_type}{A string that sets the segment line type "twodash", "solid", "longdash", "dotted", "dotdash",
"dashed", "blank".}

\item{line_width}{A numeric that sets the width of the segments.}

\item{line_pts_alpha}{A numeric value that sets the alpha level of points.}

\item{panel_color}{A string in hexidecimal or color name that sets the plot panel's color.
The default is "white".}

\item{panel_border_color}{A string in hexidecimal or color name that sets the plot panel's border color.
The default is "black".}

\item{show_major_grids}{A logical that controls the appearance of major grids.}

\item{show_minor_grids}{A logical that controls the appearance of minor grids.}

\item{silent_NA_warning}{A logical that controls the appearance of a console warning when Na's
are removed.}

\item{png_file_path}{A character string with the directory and file name to produce
a png image of the plot.}

\item{png_width_height}{A numeric vector that sets the width and height of the png image in pixels. The
default is c(480,480).  There are 37.8 pixels in a centimeter.}
}
\value{
A ggplot class object.
}
\description{
Function creates a plot of scaled line segments from begin/end of continuous numeric values
 (referred to as 'measure') in either a vertical or horizontal orientation. The segments are positioned
 across the axis using discrete values or levels (referred to as 'factor'). For example, segment lines
 scaled with lower/upper values of temperature across months of a year.  In addition an optional mid-point
 such as a mean, median or difference between the lower/upper values can be plotted on the individual
 segment lines.
}
\examples{
library(ggplot2)
library(RplotterPkg)

RplotterPkg::create_range_plot(
  df = RplotterPkg::penguins_stats,
  orientation = "vertical",
  factor_var = "species",
  min_meas = "min_body_mass",
  max_meas = "max_body_mass",
  labels_meas = "avg_body_mass",
  labels = "mid_labels",
  labels_fill = "yellow",
  title = "Average and Range of Penguins Body Mass(g) by Species",
  subtitle = "Source: palmerpenguins",
  center_titles = TRUE,
  factor_title = "Species",
  meas_title = "Body Mass(g)",
  pts_fill = c("white", "red"),
  pts_size = 3,
  pts_shape = 21,
  pts_stroke = 1.7,
  line_width = 1.5,
  line_type = "solid",
  line_pts_alpha = 0.5,
  meas_limits = c(2500, 7000),
  meas_major_breaks = seq(2500,7000,500),
  rot_y_tic_label = TRUE,
  show_major_grids = TRUE,
  show_minor_grids = FALSE
)

}
