% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vs_merging_lengths.R
\name{vs_merging_lengths}
\alias{vs_merging_lengths}
\alias{merging_lengths}
\title{Length statistics after merging}
\usage{
vs_merging_lengths(
  fastq_input,
  reverse = NULL,
  minovlen = 10,
  minlen = 0,
  threads = 1,
  plot_title = TRUE,
  tmpdir = NULL
)
}
\arguments{
\item{fastq_input}{(Required). A FASTQ file path, a FASTQ tibble (forward
reads), or a paired-end tibble of class \code{"pe_df"}. See \emph{Details}.}

\item{reverse}{(Optional). A FASTQ file path or FASTQ tibble containing
reverse reads. Optional if \code{fastq_input} is a \code{"pe_df"} object.}

\item{minovlen}{(Optional). Minimum overlap between the merged reads. Must be
at least 5. Defaults to \code{10}.}

\item{minlen}{(Optional). Minimum number of bases a sequence must have to be
retained. Defaults to \code{0}. See \emph{Details}.}

\item{threads}{(Optional). Number of computational threads to be used by
\code{VSEARCH}. Defaults to \code{1}.}

\item{plot_title}{(Optional). If \code{TRUE} (default), a summary title will
be displayed in the plot. Set to \code{FALSE} for no title.}

\item{tmpdir}{(Optional). Path to the directory where temporary files should
be written when tables are used as input or output. Defaults to
\code{NULL}, which resolves to the session-specific temporary directory
(\code{tempdir()}).}
}
\value{
A tibble with the following columns:
\itemize{
  \item \code{length_1}: The length of the forward reads.
  \item \code{length_2}: The length of the reverse reads.
  \item \code{length_merged}: The length of the merged reads.
  \item \code{length_overlap}: The length of the overlap between the forward
  and reverse reads.
}

In case of missing values for the latter two columns, it means that the
corresponding reads were not merged.

The tibble includes additional attributes:
\describe{
  \item{\code{plot}}{A \code{\link[ggplot2]{ggplot2}} object visualizing the
  returned data frame.}
  \item{\code{statistics}}{Additional statistics returned from
  \code{\link{vs_fastq_mergepairs}}.}
}
}
\description{
\code{vs_merging_lengths} computes length statistics for forward
reads, reverse reads, merged reads, and their overlaps before and after
merging.
}
\details{
The function uses \code{\link{vs_fastq_mergepairs}} where
the arguments to this function are described in detail.

If \code{fastq_input} is an object of class \code{"pe_df"}, the reverse reads
are automatically extracted from its \code{"reverse"} attribute unless
explicitly provided via the \code{reverse} argument. This allows streamlined
input handling for paired-end tibbles created by
\code{\link{fastx_synchronize}} or \code{\link{vs_fastx_trim_filt}}.

These length statistics are most typically used in order to tune the filter
and trimming of reads such that the merged reads are of high quality.
}
\examples{
\dontrun{
# Define arguments
R1.file <- file.path(file.path(path.package("Rsearch"), "extdata"),
                     "small_R1.fq")
R2.file <- file.path(file.path(path.package("Rsearch"), "extdata"),
                     "small_R2.fq")

# Run function
merging.tbl <- vs_merging_lengths(fastq_input = R1.file,
                                  reverse = R2.file)

# Display plot
merging_stats_plot <- attr(merging.tbl, "plot")
print(merging_stats_plot)

}
}
\references{
\url{https://github.com/torognes/vsearch}
}
\seealso{
\code{\link{vs_fastq_mergepairs}}
}
