% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_states.R
\name{check_states}
\alias{check_states}
\title{Check if the records fall in the state assigned in the metadata}
\usage{
check_states(
  occ,
  long = "decimalLongitude",
  lat = "decimalLatitude",
  state_column,
  distance = 5,
  try_to_fix = FALSE,
  progress_bar = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{occ}{(data.frame) a dataset with occurrence records, preferably with
country information standardized using \code{standardize_states()}.}

\item{long}{(character) column name with longitude. Default is
'decimalLongitude'.}

\item{lat}{lat (character) column name with latitude. Default is
'decimalLatitude'.}

\item{state_column}{(character) column name containing the state information.}

\item{distance}{(numeric) maximum distance (in kilometers) a record can fall
outside the state assigned in the \code{state_column}. Default is \code{5}.}

\item{try_to_fix}{(logical) whether to check if coordinates are inverted or
transposed (see \code{fix_states()} for details). If \code{TRUE}, coordinates
identified as inverted or transposed will be corrected. Default is \code{FALSE}.}

\item{progress_bar}{(logical) whether to display a progress bar during
processing. If TRUE, the 'pbapply' package must be installed. Default is
\code{FALSE}.}

\item{verbose}{(logical) whether to print messages about function progress.
Default is \code{TRUE}.}
}
\value{
The original \code{occ} data.frame with an additional column (\code{correct_state})
indicating whether each record falls within the state specified in the
metadata (\code{TRUE}) or not (\code{FALSE}).
}
\description{
Check if the records fall in the state assigned in the metadata
}
\examples{
# Load example data
data("occurrences", package = "RuHere") #Import data example
# Subset occurrences for Araucaria angustifolia
occ <- occurrences[occurrences$species == "Araucaria angustifolia", ]
# Standardize country names
occ_country <- standardize_countries(occ = occ,
                                     return_dictionary = FALSE)
# Standardize state names
occ_state <- standardize_states(occ = occ_country,
                                country_column = "country_suggested",
                                return_dictionary = FALSE)
# Check whether records fall within assigned states
occ_state_checked <- check_states(occ = occ_state,
                                    state_column = "state_suggested")
}
