% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{states}
\alias{states}
\title{Administrative Units (States, Provinces, and Regions)}
\format{
A \code{PackedSpatVector} object with polygons of administrative divisions
and one attribute:
\describe{
\item{name}{State/province/region name.}
}
}
\source{
Natural Earth data, via \strong{rnaturalearth}.
}
\usage{
states
}
\description{
A simplified \code{PackedSpatVector} containing state-level polygons (e.g.,
provinces, departments, regions) for countries worldwide. Names and parent
countries (\code{geonunit}) were cleaned (lowercase, accents removed).
}
\details{
The dataset was generated from \code{rnaturalearth::ne_states()}. The following
processing steps were applied:
\itemize{
\item kept only administrative types: \code{"Province"}, \code{"State"},
\code{"Department"}, \code{"Region"}, \code{"Federal District"};
\item selected only \code{"name"} and \code{"geonunit"} columns;
\item both fields were cleaned via \code{tolower()} and \code{remove_accent()};
\item records where state name = country name were removed;
\item geometries were simplified using \code{terra::simplifyGeom(tolerance = 0.05)};
\item wrapped with \code{terra::wrap()} for internal storage.
}
}
\examples{
data(states)
states <- terra::unwrap(states)
terra::plot(states)
}
\keyword{datasets}
