% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addReleve.R
\name{addReleve}
\alias{addReleve}
\title{addReleve:
Digitize and Edit Relevés in an Rveg Database}
\usage{
addReleve(
  database = "NEW",
  save = "default",
  checklist = "default",
  customhead = NULL,
  extrahead = NULL,
  metadata = NULL
)
}
\arguments{
\item{database}{Character. The path and name of an existing Rveg database
(e.g., \code{"path/to/my_db"}). Defaults to \code{"NEW"} which creates a fresh database.}

\item{save}{Character. The output path and name where the resulting database
files (\verb{*HEAD.csv} and \verb{*REL.csv}) will be exported. Defaults to a temporary directory.}

\item{checklist}{Character. The species checklist to use. Can be a built-in
checklist (atm: \code{cz_dh2012}, \code{Czechia_slovakia_2015}, \code{cz_kaplan2019}, \code{wcvp_que},
\code{wcvp_por}) or a file path to a custom \code{txt} checklist. Default use \code{cz_dh2012}.
see function \code{\link{CreateChecklist}}.}

\item{customhead}{Character vector. A vector of strings defining completely
custom header fields. Overrides the default schema.}

\item{extrahead}{Character vector. Additional header fields to append to the
end of the default or existing header schema.}

\item{metadata}{Character vector of length 2. Used to store the Project Title
and Project Description (e.g., \code{c("Alpine Flora", "Summer 2024 survey")}).}
}
\value{
Writes two linked CSV files (Rveg database) to the location specified by \code{save}: one
containing the relevé species data (\verb{*REL.csv}) and one containing the header data (\verb{*HEAD.csv}).
}
\description{
The core interactive function of the \code{Rveg} package. \code{addReleve()} launches a
console-based menu system that allows users to create new vegetation databases,
digitize new relevés, and edit existing ones. It seamlessly manages both the
species composition data (REL) and the environmental plot header data (HEAD).
Parameter \code{start} was removed.

\emph{For list of commands in addReleve menu prompt \code{help} or \verb{?}}
}
\examples{
if (interactive()) {
  # Launch the interactive menu for a new database
  addReleve(
    database = "NEW",
    save = "my_new_project",
    metadata = c("Project Title", "Project Description")
  )
}

}
