% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_auxiliary.R
\name{plot_residuals}
\alias{plot_residuals}
\title{Plot residuals}
\usage{
plot_residuals(
  Year,
  res,
  res_sd = NULL,
  res_sd_CI = 0.95,
  res_upper = NULL,
  res_lower = NULL,
  res_ind_blue = NULL,
  draw_zero = TRUE,
  zero_linetype = 2,
  label = "Residual"
)
}
\arguments{
\item{Year}{A vector of years for the data.}

\item{res}{A vector of residuals.}

\item{res_sd}{A vector of year specific standard deviation for \code{res}.}

\item{res_sd_CI}{The confidence interval for the error bars based for \code{res_sd}.}

\item{res_upper}{A vector of year-specific upper bounds for the error bars of the residual (in lieu of argument \code{res_CV}).}

\item{res_lower}{A vector of year-specific lower bounds for the error bars of the residual (in lieu of argument \code{res_CV}).}

\item{res_ind_blue}{Indices of \code{obs} for which the plotted residuals and error bars will be blue.}

\item{draw_zero}{Indicates whether a horizontal line should be drawn at zero.}

\item{zero_linetype}{Passes argument \code{lty} (e.g. solid line = 1, dotted = 2) to \code{draw_zero}.}

\item{label}{Character string that describes the data to label the y-axis.}
}
\value{
A plot of model residuals by year (optionally, with error bars).
}
\description{
Plots figure of residuals (or any time series with predicted mean of zero).
}
\seealso{
\code{\link[=plot_timeseries]{plot_timeseries()}}
}
\author{
Q. Huynh
}
