% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regression_outcome_scb.R
\name{SCB_regression_outcome}
\alias{SCB_regression_outcome}
\title{Simultaneous Confidence Bands for Regression Outcomes or Coefficients}
\usage{
SCB_regression_outcome(
  df_fit,
  model,
  grid_df = NULL,
  n_boot = 1000,
  alpha = 0.05,
  grid_df_boot = NULL,
  type = "linear",
  fitted = TRUE,
  w = NULL
)
}
\arguments{
\item{df_fit}{A data frame containing the training design matrix used
to fit the linear model. Acceptable input format includes numeric and factor.}

\item{model}{A character string representing the formula for the linear model
(e.g., \code{"y ~ x1 + x2"}).}

\item{grid_df}{A data frame specifying the covariate settings that define the
mean outcome or linear combination for which simultaneous confidence bands (SCB)
are constructed.
Each row represents one covariate combination at which predictions and
SCBs are evaluated. Column names should match variables in the fitted model,
but \code{grid_df} may include only the subset of covariates of interest for the SCB
(it is not required to cover all model variables).
Default is \code{NULL}, in which case the SCB is constructed over the fitted values
based on 'df_fit`.}

\item{n_boot}{Number of bootstrap samples used in the non-parametric bootstrap
procedure to generate the empirical distribution. Default is 1000.}

\item{alpha}{Significance level for the confidence band
(e.g., 0.05 for 95\% confidence). Default is 0.05.}

\item{grid_df_boot}{An optional data frame specifying the input grid at which
predictions are evaluated during bootstrap resampling.
This allows SCBs to be constructed on a denser set of covariate values
if desired. If NULL, uses \code{grid_df}.
If \code{grid_df} is set to NULL, \code{grid_df_boot} will also be set to \code{NULL}.
This argument is only for \code{type} = \code{linear}.}

\item{type}{A character string specifying the model type. Either \code{"linear"}
(default) or \code{"logistic"}.}

\item{fitted}{Logical. Whether to estimate the simultaneous confidence bands
for regression outcomes or coefficients.
\itemize{
\item \code{TRUE} - Estimate the simultaneous confidence bands
for regression outcomes.
\item \code{FALSE} - estimate the simultaneous confidence bands
for regression coefficients.
}
Default is \code{TRUE}.}

\item{w}{A numeric matrix that specifies the linear combinations of regression coefficients
for which simultaneous confidence bands (SCBs) are to be constructed.
The number of columns should be equal to the number of coefficients in the
regression model fitted.
Default is NULL, will return SCBs for all coefficients and the intercept.
This argument is only for \code{fitted} = \code{FALSE}.}
}
\value{
A data frame with the following columns:
\describe{
\item{scb_low}{Lower bound of the simultaneous confidence band.}
\item{Mean}{Predicted mean response from the fitted model.}
\item{scb_up}{Upper bound of the simultaneous confidence band.}
\item{...}{All columns from \code{grid_df}, representing the prediction grid.
Optional, if \code{fitted} = \code{TRUE}}
}
}
\description{
This function fits a user-specified regression model (linear or logistic),
and constructs simultaneous confidence bands (SCBs) for either the mean outcome
or the regression coefficients. SCBs are obtained using a nonparametric bootstrap
procedure evaluated on a fixed test design matrix, providing simultaneous
inference across the entire range of covariates or parameters of interest.
}
\examples{
set.seed(262)
x1 <- rnorm(100)
x2 <- rnorm(100)
epsilon <- rnorm(100,0,sqrt(2))
y <- -1 + x1 + x2 + epsilon
df <- data.frame(x1 = x1, x2 = x2, y = y)
grid <- data.frame(x1 = seq(-1, 1, length.out = 100), x2 = seq(-1, 1, length.out = 100))
model <- "y ~ x1 + x2"
w <- matrix(c(0, 1, 1), ncol = 3)
results <- SCB_regression_outcome(df_fit = df, model = model, grid_df = grid,
                                  w = w, n_boot = 100)

}
\references{
Ren, J., Telschow, F. J. E., & Schwartzman, A. (2024).
Inverse set estimation and inversion of simultaneous confidence intervals.
\emph{Journal of the Royal Statistical Society: Series C (Applied Statistics)}, 73(4), 1082–1109.
\doi{10.1093/jrsssc/qlae027}
}
