% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simPoisBin.R
\name{simPoisBin}
\alias{simPoisBin}
\title{Simulate Poisson-Binomial Dynamic GLM}
\usage{
simPoisBin(N = 1000L, n = 10L, q = 4L)
}
\arguments{
\item{N}{Integer > 1, number of time points/individuals.}

\item{n}{Integer > 0, binomial number of trials (constant across units).}

\item{q}{Integer > 0, number of predictors (including intercept if desired).}
}
\value{
A list with components:
\item{X}{N x q design matrix.}
\item{Y}{Integer vector of length N, counts of successes.}
\item{beta}{N x q matrix of dynamic regression coefficients.}
\item{G}{q x q autoregressive multiplier matrix (diagonal).}
\item{Sig}{q x q innovation covariance matrix (diagonal).}
}
\description{
Generates a dynamic regression dataset where each response
y_i | p_i ~ Binomial(n, p_i) with p_i = plogis(x_i' beta_i).
The latent coefficients beta_i follow a Vector-AR(1) process.
}
\examples{
set.seed(1)
dat <- simPoisBin(N = 500, n = 10, q = 4)
head(dat$Y)

}
