% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maximin.R
\name{maximin.optim}
\alias{maximin.optim}
\title{Optimize a design based on maximin or reciprocal distance criterion}
\usage{
maximin.optim(D.ini, iteration = 10, sa = FALSE, find.best.ini = FALSE)
}
\arguments{
\item{D.ini}{the initial design.}

\item{iteration}{number iterations for L-BFGS-B algorithm.}

\item{sa}{whether to use simulated annealing in the end. If sa=TRUE, continuous optimization is first used to optimize the reciprocal distance criterion and then SA is performed to optimize the maximin criterion.}

\item{find.best.ini}{whether to generate other initial designs. If find.best.ini=TRUE, it will first find the closest full factorial design in terms of size to \code{D.ini}. If the size of the full factorial design is larger than \code{D.ini}, design points will be removed by the \code{maximin.remove} function. If the the size of the full factorial design is smaller than \code{D.ini}, then we will augment the design by \code{maximin.augment}. In this case, we have two different candidate set to choose from: one is a full factorial design with level+1 and another is Sobol points. All initial designs are optimized and the best is returned.}
}
\value{
\item{design}{the optimized design.}
\item{D.ini}{initial designs. If find.best.ini=TRUE, a list will be returned containing all the initial designs considered.}
}
\description{
This function optimizes a design by continuous optimization based on reciprocal distance criterion. A simulated annealing step can be enabled in the end to directly optimize the maximin distance criterion.
}
\details{
\code{maximin.optim} optimizes a design by L-BFGS-B algorithm (Liu and Nocedal 1989) based on the reciprocal distance criterion. A simulated annealing step can be enabled in the end to directly optimize the maximin distance criterion. Optimization detail can be found in \code{\link{continuous.optim}}. We also provide the option to try other initial designs generated internally besides the \code{D.ini} provided by the user (see argument \code{find.best.ini}).
}
\examples{
n = 20
p = 3
D = maximinLHD(n, p)$design
D = maximin.optim(D, sa=FALSE)$design
# D = maximin.optim(D, sa=TRUE)$design # Let sa=TRUE only when the n and p is not large.

}
\references{
Liu, D. C., & Nocedal, J. (1989). On the limited memory BFGS method for large scale optimization. Mathematical programming, 45(1), 503-528.
}
