% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dyntaxa_api_functions.R
\name{match_dyntaxa_taxa}
\alias{match_dyntaxa_taxa}
\title{Match Dyntaxa taxon names}
\usage{
match_dyntaxa_taxa(
  taxon_names,
  subscription_key = Sys.getenv("DYNTAXA_KEY"),
  multiple_options = FALSE,
  searchFields = "Both",
  isRecommended = "NotSet",
  isOkForObservationSystems = "NotSet",
  culture = "sv_SE",
  page = 1,
  pageSize = 100,
  verbose = TRUE
)
}
\arguments{
\item{taxon_names}{A vector of taxon names to match.}

\item{subscription_key}{A Dyntaxa API subscription key. By default, the key
is read from the environment variable \code{DYNTAXA_KEY}.

You can provide the key in three ways:
\itemize{
\item \strong{Directly as a parameter}:
\code{match_dyntaxa_taxa("Skeletonema marinoi", subscription_key = "your_key_here")}.
\item \strong{Temporarily for the session}:
\code{Sys.setenv(DYNTAXA_KEY = "your_key_here")}.
After this, you do not need to pass \code{subscription_key} to the function.
\item \strong{Permanently across sessions} by adding it to your \code{~/.Renviron} file.
Use \code{usethis::edit_r_environ()} to open the file, then add:
\code{DYNTAXA_KEY=your_key_here}.
After this, you do not need to pass \code{subscription_key} to the function.
}}

\item{multiple_options}{Logical. If TRUE, the function will return multiple matching names. Default is FALSE, selecting the first match.}

\item{searchFields}{A character string indicating the search fields. Defaults to 'Both'.}

\item{isRecommended}{A character string indicating whether the taxon is recommended. Defaults to 'NotSet'.}

\item{isOkForObservationSystems}{A character string indicating whether the taxon is suitable for observation systems. Defaults to 'NotSet'.}

\item{culture}{A character string indicating the culture. Defaults to 'sv_SE'.}

\item{page}{An integer specifying the page number for pagination. Defaults to 1.}

\item{pageSize}{An integer specifying the page size for pagination. Defaults to 100.}

\item{verbose}{Logical. Print progress bar. Default is TRUE.}
}
\value{
A \code{tibble} containing the search pattern, taxon ID, and best match for each taxon name.
}
\description{
This function matches a list of taxon names against the SLU Artdatabanken API (Dyntaxa) and retrieves the best matches along with their taxon IDs.
}
\details{
A valid Dyntaxa API subscription key is required.
You can request a free key for the "Taxonomy" service from the ArtDatabanken API portal:
\url{https://api-portal.artdatabanken.se/}

\strong{Note}: Please review the \href{https://www.slu.se/artdatabanken/rapportering-och-fynd/oppna-data-och-apier/}{API conditions}
and \href{https://api-portal.artdatabanken.se/}{register for access} before using the API. Data collected through the API
is stored at SLU Artdatabanken. Please also note that the authors of \code{SHARK4R} are not affiliated with SLU Artdatabanken.
}
\examples{
\dontrun{
# Match taxon names against SLU Artdatabanken API
matched_taxa <- match_dyntaxa_taxa(c("Homo sapiens", "Canis lupus"), "your_subscription_key")
print(matched_taxa)
}

}
\seealso{
\href{https://api-portal.artdatabanken.se/}{SLU Artdatabanken API Documentation}
}
