% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algaebase_api_functions.R
\name{parse_scientific_names}
\alias{parse_scientific_names}
\title{Parse scientific names into genus and species components.}
\usage{
parse_scientific_names(
  scientific_names,
  remove_undesired_descriptors = TRUE,
  remove_subspecies = TRUE,
  remove_invalid_species = TRUE,
  encoding = "UTF-8",
  scientific_name = deprecated()
)
}
\arguments{
\item{scientific_names}{A character vector containing scientific names, which may include binomials, additional descriptors, or varieties.}

\item{remove_undesired_descriptors}{Logical, if TRUE, undesired descriptors (e.g., 'Cfr.', 'cf.', 'colony', 'cells', etc.) are removed. Default is TRUE.}

\item{remove_subspecies}{Logical, if TRUE, subspecies/variety descriptors (e.g., 'var.', 'subsp.', 'f.', etc.) are removed. Default is TRUE.}

\item{remove_invalid_species}{Logical, if TRUE, invalid species names (e.g., 'sp.', 'spp.') are removed. Default is TRUE.}

\item{encoding}{A string specifying the encoding to be used for the input names (e.g., 'UTF-8'). Default is 'UTF-8'.}

\item{scientific_name}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
Use \code{scientific_names} instead.}
}
\value{
A \code{tibble} with two columns:
\itemize{
\item \code{genus} — Genus names.
\item \code{species} — Species names (empty if unavailable or invalid).
Invalid descriptors such as \code{"sp."}, \code{"spp."}, and numeric entries
are excluded from this column.
}
}
\description{
This function processes a character vector of scientific names, splitting them into genus and species components.
It handles binomial names (e.g., "Homo sapiens"), removes undesired descriptors (e.g., 'Cfr.', 'cf.', 'sp.', 'spp.'),
and manages cases involving varieties, subspecies, or invalid species names. Special characters and whitespace are handled appropriately.
}
\examples{
# Example with a vector of scientific names
scientific_names <- c("Skeletonema marinoi", "Cf. Azadinium perforatum", "Gymnodinium sp.",
                      "Melosira varians", "Aulacoseira islandica var. subarctica")

# Parse names
result <- parse_scientific_names(scientific_names)

# Check the resulting data
print(result)

}
\seealso{
\url{https://www.algaebase.org/} for AlgaeBase website.
}
