% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/siberConvexhull.R
\name{siberConvexhull}
\alias{siberConvexhull}
\title{Calculate metrics and plotting information for convex hulls}
\usage{
siberConvexhull(x, y)
}
\arguments{
\item{x}{a vector of x-axis data}

\item{y}{a vector of y-axis data}
}
\value{
A list of length four comprising:
\itemize{
\item \code{TA} the area of the convex hull.
\item \code{hullX} the x-coordinates of the points describing the convex hull.
\item \code{hullY} the y-coordinates of the points describing the convex hull.
\item \code{ind} the indices of the original data in \code{x} and \code{y} that
form the boundaries of the convex hull.
}
}
\description{
This function calculates the area of the convex hull describing a set of
bivariate points, and returns other information useful for plotting the hull.
}
\examples{
x <- stats::rnorm(15)
y <- stats::rnorm(15)
siberConvexhull(x, y)

}
