% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SQUIRE.R
\name{SQUIRE}
\alias{SQUIRE}
\title{SQUIRE: Statistical Quality-Assured Integrated Response Estimation}
\usage{
SQUIRE(
  data,
  treatments,
  control_treatment = treatments[1],
  validation_level = 0.05,
  min_timepoints = 5,
  min_replicates = 3,
  verbose = TRUE
)
}
\arguments{
\item{data}{Data frame with columns: time, response, treatment, replicate}

\item{treatments}{Character vector of treatment names}

\item{control_treatment}{Name of control treatment for comparisons}

\item{validation_level}{Statistical significance level (default: 0.05)}

\item{min_timepoints}{Minimum timepoints required for fitting (default: 5)}

\item{min_replicates}{Minimum replicates per treatment (default: 3)}

\item{verbose}{Logical, print progress messages}
}
\value{
List with validation results, systematic GALAHAD discovery, and final parameters
}
\description{
Systematic adaptive GALAHAD framework:
  1. Statistical validation
  2. Systematic T->P->E geometry discovery (3 focused runs)
  3. Final optimization with discovered optimal settings
  4. Done!
}
\examples{
\donttest{
# Synthetic germination data for demonstration
test_data <- data.frame(
  time = rep(c(0, 1, 2, 3, 4, 5, 6, 7), times = 12),
  treatment = rep(c("Control", "Contaminant_A", "Contaminant_B"), each = 32),
  replicate = rep(rep(1:4, each = 8), times = 3),
  response = c(
    0, 5, 15, 28, 45, 62, 75, 82,    # Control
    0, 4, 12, 26, 43, 60, 73, 80,
    0, 6, 17, 30, 47, 64, 77, 84,
    0, 5, 14, 27, 44, 61, 74, 81,
    0, 2, 8, 18, 32, 48, 60, 68,     # Contaminant_A
    0, 3, 7, 16, 30, 46, 58, 66,
    0, 2, 9, 19, 34, 50, 62, 70,
    0, 3, 8, 17, 31, 47, 59, 67,
    0, 8, 22, 38, 55, 72, 85, 92,    # Contaminant_B
    0, 7, 20, 36, 53, 70, 83, 90,
    0, 9, 24, 40, 57, 74, 87, 94,
    0, 8, 21, 37, 54, 71, 84, 91
  )
)

result <- SQUIRE(test_data, c("Control", "Contaminant_A", "Contaminant_B"))
if (result$optimization_performed) {
  print(result$parameters$parameter_matrix)
}
}

}
