% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate_by_pkg.R
\name{aggregate_by_pkg}
\alias{aggregate_by_pkg}
\title{Aggregate by base R or data.table}
\usage{
aggregate_by_pkg(
  data,
  by,
  var,
  pkg = "base",
  include_na = FALSE,
  fun = sum,
  base_order = TRUE,
  ...
)
}
\arguments{
\item{data}{A data frame}

\item{by}{A character vector specifying the column names to group by.}

\item{var}{A character vector specifying the column names of the variables to be aggregated.}

\item{pkg}{A character string indicating which package to use for aggregation.
Must be either \code{"base"} for base R or \code{"data.table"} for \code{data.table}. Default is \code{"base"}.}

\item{include_na}{A logical value indicating whether \code{NA} values in the grouping variables should be included in the aggregation. Default is \code{FALSE}.}

\item{fun}{The function to be applied for aggregation. Default is \code{sum}.}

\item{base_order}{A logical value indicating whether to attempt to return the results in the same order as base R when using \code{data.table}.
Note that while the function strives to maintain this order, it cannot be guaranteed due to potential variations in
sorting behavior across different systems. Default is \code{TRUE}.}

\item{...}{Further arguments passed to \code{\link{aggregate}} when \code{pkg} is \code{"base"}}
}
\value{
A data.frame containing the aggregated results.
}
\description{
This function aggregates data by specified grouping variables, using either base R or \code{data.table}.
}
\examples{
d <- SSBtoolsData("d2")[1:20, ]
d[[2]] <- as.numeric(d[[2]])
d$y <- as.numeric(1:20)
d$y[2] <- NA
d$county[8:9] <- NA
d$main_income[11:12] <- NA
d$k_group[19:20] <- NA
by <- c("main_income", "county", "k_group")

a1 <- aggregate_by_pkg(d, by = by, var = c("y", "freq"))
a2 <- aggregate_by_pkg(d, by = by, var = c("y", "freq"), 
                       include_na = TRUE)
a3 <- aggregate_by_pkg(d, by = by, var = c("y", "freq"), 
                       include_na = TRUE, fun = function(x) list(x))
 
if (requireNamespace("data.table", quietly = TRUE)) {  
                       
  b1 <- aggregate_by_pkg(d, by = by, var = c("y", "freq"), pkg = "data.table")
  b2 <- aggregate_by_pkg(d, by = by, var = c("y", "freq"), pkg = "data.table", 
                         include_na = TRUE)
  b3 <- aggregate_by_pkg(d, by = by, var = c("y", "freq"), pkg = "data.table", 
                         include_na = TRUE, fun = function(x) list(x))                        
                       
  print(identical(a1, b1))   # TRUE when base_order succeeds
  print(identical(a2, b2))
  print(identical(a3, b3))
  
}  else {
   print("The 'data.table' package is not installed.")
}
                        
}
