% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_entropy.R
\name{get_entropy}
\alias{get_entropy}
\title{Per-Row Entropy of Posterior Cluster Probabilities}
\usage{
get_entropy(dat, n, p, g, pi = NULL, mu = NULL, sigma = NULL, paralist = NULL)
}
\arguments{
\item{dat}{Numeric matrix \eqn{n \times p}. The data matrix.}

\item{n}{Integer. Number of rows in \code{dat}.}

\item{p}{Integer. Number of columns (features) in \code{dat}.}

\item{g}{Integer. Number of mixture components.}

\item{pi}{Optional numeric vector length \eqn{g}. Mixing proportions (sum to 1).}

\item{mu}{Optional numeric matrix \eqn{p \times g}. Column \eqn{j} is the mean of component \eqn{j}.}

\item{sigma}{Optional numeric matrix \eqn{p \times p} (shared covariance) or array
\eqn{p \times p \times g} (component-specific covariances).}

\item{paralist}{Optional list with elements \code{pi}, \code{mu}, \code{sigma}.
If supplied, these take precedence over the corresponding explicit arguments.}
}
\value{
Numeric vector of length \eqn{n}, the entropy per observation (in nats).
}
\description{
Compute the Shannon entropy (in nats) of posterior membership probabilities
for each observation, given a Gaussian mixture model. Posterior probabilities
\eqn{\tau_{ij}} are obtained via \code{get_clusterprobs()}.
}
\examples{
  # Suppose you have get_clusterprobs(), and a fitted/pi, mu, sigma:
  n <- 100; p <- 2; g <- 2
  X <- matrix(rnorm(n * p), n, p)
  pi <- c(0.6, 0.4)
  mu <- cbind(c(0,0), c(1,1))
  Sigma <- array(0, dim = c(p, p, g))
  Sigma[,,1] <- diag(p); Sigma[,,2] <- diag(p)
  ent <- get_entropy(dat = X, n = n, p = p, g = g, pi = pi, mu = mu, sigma = Sigma)
  summary(ent)

}
\seealso{
\code{\link{get_clusterprobs}}
}
