test_that("afv_sites", {
	expect_true(is.list(site.list_afv))
	expect_equal(length(site.list_afv), 2)
	expect_true("obs" %in% names(site.list_afv))
	expect_equal(dim(site.list_afv$obs), c(45, 22))
	expect_true("afvArea" %in% names(site.list_afv$obs))
	expect_equal(site.list_afv$obs$afvArea[1:2], c(0.171, 0.171), tolerance = 0.001)
	expect_true(all(site.list_afv$obs$afvArea >= 0))
	expect_s3_class(site.list_afv$obs, "sf")
	expect_true("pred1km" %in% names(site.list_afv))
	expect_equal(dim(site.list_afv$pred1km), c(175, 15))
	expect_true("afvArea" %in% names(site.list_afv$pred1km))
	expect_equal(site.list_afv$pred1km$afvArea[1:2], c(0.171, 0.171), tolerance = 0.001)
	expect_true(all(site.list_afv$pred1km$afvArea >= 0))
	expect_s3_class(site.list_afv$pred1km, "sf")
})
