# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Fast Row-wise Moran's I Calculation
#'
#' Computes Moran's I statistic for multiple genes (rows) against a
#' precomputed spatial weights matrix.
#'
#' @param expr_matrix Numeric matrix (genes x spots)
#' @param W Spatial weights matrix (spots x spots)
#'
#' @return Numeric vector of Moran's I values for each gene
#'
#' @details
#' This function is optimized using Armadillo linear algebra library.
#' It computes: I = (n/W_sum) * (z' * W * z) / (z' * z)
#' where z = x - mean(x) for each gene.
#'
#' @keywords internal
moranI_cpp <- function(expr_matrix, W) {
    .Call(`_SVG_moranI_cpp`, expr_matrix, W)
}

#' Fast Moran's I with Full Statistics
#'
#' Computes Moran's I along with expected value and standard deviation
#' under the null hypothesis. Optimized with Armadillo vectorization.
#'
#' @param expr_matrix Numeric matrix (genes x spots)
#' @param W Spatial weights matrix (spots x spots), row-standardized
#'
#' @return List containing observed I, expected I, and standard deviation
#'
#' @details
#' This function pre-computes all weight matrix statistics once, then
#' loops over genes efficiently. The main bottleneck is the z * W * z'
#' computation which is O(n^2) per gene.
#'
#' @keywords internal
moranI_full_cpp <- function(expr_matrix, W) {
    .Call(`_SVG_moranI_full_cpp`, expr_matrix, W)
}

#' Fast Binarization using K-means (k=2)
#'
#' Binarizes each row of an expression matrix using k-means clustering.
#'
#' @param expr_matrix Numeric matrix (genes x spots)
#' @param max_iter Maximum iterations for k-means
#'
#' @return Integer matrix of binary values (0/1)
#'
#' @keywords internal
binarize_kmeans_cpp <- function(expr_matrix, max_iter = 20L) {
    .Call(`_SVG_binarize_kmeans_cpp`, expr_matrix, max_iter)
}

#' Fast Distance Matrix Computation
#'
#' Computes pairwise Euclidean distance matrix for spatial coordinates.
#'
#' @param coords Numeric matrix of coordinates (spots x 2)
#'
#' @return Symmetric distance matrix
#'
#' @keywords internal
dist_matrix_cpp <- function(coords) {
    .Call(`_SVG_dist_matrix_cpp`, coords)
}

#' Build KNN Adjacency Matrix
#'
#' Constructs K-nearest neighbor adjacency matrix.
#'
#' @param coords Numeric matrix of coordinates
#' @param k Number of neighbors
#'
#' @return Binary adjacency matrix
#'
#' @keywords internal
knn_adj_cpp <- function(coords, k) {
    .Call(`_SVG_knn_adj_cpp`, coords, k)
}

#' Compute Fisher's Exact Test for Spatial Enrichment
#'
#' Fast computation of contingency table and Fisher test p-value
#' for binary spatial enrichment.
#'
#' @param bin_vec Binary vector for one gene
#' @param from_idx Vector of source indices for edges
#' @param to_idx Vector of target indices for edges
#'
#' @return List with contingency table counts, odds ratio, and p-value
#'
#' @keywords internal
fisher_spatial_cpp <- function(bin_vec, from_idx, to_idx) {
    .Call(`_SVG_fisher_spatial_cpp`, bin_vec, from_idx, to_idx)
}

