% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{moranI_cpp}
\alias{moranI_cpp}
\title{Fast Row-wise Moran's I Calculation}
\usage{
moranI_cpp(expr_matrix, W)
}
\arguments{
\item{expr_matrix}{Numeric matrix (genes x spots)}

\item{W}{Spatial weights matrix (spots x spots)}
}
\value{
Numeric vector of Moran's I values for each gene
}
\description{
Computes Moran's I statistic for multiple genes (rows) against a
precomputed spatial weights matrix.
}
\details{
This function is optimized using Armadillo linear algebra library.
It computes: I = (n/W_sum) * (z' * W * z) / (z' * z)
where z = x - mean(x) for each gene.
}
\keyword{internal}
