% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{simulate_semipar_data}
\alias{simulate_semipar_data}
\title{Simulate Spatiotemporal Mixed Frequency Data}
\usage{
simulate_semipar_data(
  n_side = 6,
  t_len = 50,
  k = 3,
  rho_error = 0.5,
  beta = 0.5,
  gamma = 0.3
)
}
\arguments{
\item{n_side}{Integer. Grid side length. Total locations N = n_side^2.}

\item{t_len}{Integer. Length of the time series (T).}

\item{k}{Integer. Frequency ratio (e.g., 3 months per quarter).}

\item{rho_error}{Numeric. Autocorrelation coefficient for the error term (default 0.5).}

\item{beta}{True coefficient for covariate Z (default 0.5).}

\item{gamma}{True coefficient for neighborhood variable W (default 0.3).}
}
\value{
A list containing:
\item{data}{An \code{sf} object containing Y, Z, W, and geometry.}
\item{X_high}{An array (N x T x K) of high-frequency covariates.}
\item{true_params}{List of true parameters used for generation.}
}
\description{
Generates a synthetic dataset for testing the SemiparMF model.
Structure follows Equation (7) in Malabanan et al. (2022).
}
\examples{
# Generate a small dataset
sim <- simulate_semipar_data(n_side = 4, t_len = 10, k = 3)

# Check dimensions
dim(sim$data) # 160 x 5 (16 locations * 10 time points)
dim(sim$X_high) # 16 x 10 x 3

}
