% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assay.R
\name{$.Assay}
\alias{$.Assay}
\alias{$<-.Assay}
\title{Layer Data}
\usage{
\method{$}{Assay}(x, i)

\method{$}{Assay}(x, i) <- value
}
\arguments{
\item{x}{An \code{\link{Assay}} object}

\item{i}{Name of layer data to get or set}

\item{value}{A matrix-like object to add as a new layer}
}
\value{
{$}: Layer data for layer \code{i}

\code{$<-}: \code{x} with layer data \code{value} saved as \code{i}
}
\description{
Get and set layer data
}
\examples{
rna <- pbmc_small[["RNA"]]

# Fetch a layer with `$`
rna$data[1:10, 1:4]

# Add a layer with `$`
rna$data <- rna$counts
rna$data[1:10, 1:4]

}
\seealso{
v3 Assay object, validity, and interaction methods:
\code{\link{Assay-class}},
\code{\link{Assay-validity}},
\code{\link{CreateAssayObject}()},
\code{\link{[.Assay}()},
\code{\link{[[.Assay}()},
\code{\link{dim.Assay}()},
\code{\link{dimnames.Assay}()},
\code{\link{merge.Assay}()},
\code{\link{split.Assay}()},
\code{\link{subset.Assay}()}
}
\concept{assay}
