% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assay.R
\name{colMeans,Assay-method}
\alias{colMeans,Assay-method}
\alias{colSums,Assay-method}
\alias{rowMeans,Assay-method}
\alias{rowSums,Assay-method}
\title{Row and Column Sums and Means}
\usage{
\S4method{colMeans}{Assay}(x, na.rm = FALSE, dims = 1, ..., slot = "data")

\S4method{colSums}{Assay}(x, na.rm = FALSE, dims = 1, ..., slot = "data")

\S4method{rowMeans}{Assay}(x, na.rm = FALSE, dims = 1, ..., slot = "data")

\S4method{rowSums}{Assay}(x, na.rm = FALSE, dims = 1, ..., slot = "data")
}
\arguments{
\item{x}{An \code{\link{Assay}} object}

\item{na.rm}{logical.  Should missing values (including \code{NaN})
    be omitted from the calculations?}

\item{dims}{completely ignored by the \code{Matrix} methods.}

\item{...}{Ignored}

\item{slot}{Name of assay expression matrix to calculate column/row
means/sums on}
}
\value{
\code{colMeans}: The column (cell-wise) means of \code{slot}

\code{colSums}: The column (cell-wise) sums of \code{slot}

\code{rowMeans}: The row (feature-wise) means of \code{slot}

\code{rowSums}: The row (feature-wise) sums of \code{slot}
}
\description{
Calculate \code{\link{rowSums}}, \code{\link{colSums}},
\code{\link{rowMeans}}, and \code{\link{colMeans}} on \code{Assay} objects
}
\examples{
rna <- pbmc_small[["RNA"]]

colMeans(rna)

colSums(rna)

rowMeans(rna)

rowSums(rna)

}
\seealso{
\code{\link{Assay}}
}
\concept{assay}
\keyword{internal}
