% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/links.R
\name{GetLinkedPeaks}
\alias{GetLinkedPeaks}
\title{Get peaks linked to genes}
\usage{
GetLinkedPeaks(object, features, assay = NULL, min.abs.score = 0)
}
\arguments{
\item{object}{A Seurat object}

\item{features}{A list of genes to find linked peaks for}

\item{assay}{Name of assay to use. If NULL, use the default assay}

\item{min.abs.score}{Minimum absolute value of the link score for a link to
be returned}
}
\description{
Retrieve peak-gene links for a given set of genes. Links must be first
obtained by running the \code{LinkPeaks} function.
}
\details{
This function is designed to obtain the stored results from running the
\code{LinkPeaks} function. Alternatively, custom peak-gene linkage methods
can be used as long as they store the gene name, peak name, and a peak-gene
score information as metadata columns named "gene," "peak," and "score"
respectively.
}
\seealso{
GetLinkedGenes
}
\concept{links}
