% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetApprox.R
\name{GetApprox}
\alias{GetApprox}
\title{Approximate a copula by a histogram density}
\usage{
GetApprox(
  Cop,
  dim = 2,
  depth = ifelse(type == 1, 10, 32),
  type = 1,
  TOL = 1000 * .Machine$double.eps
)
}
\arguments{
\item{Cop}{A function defining the copula.}

\item{dim}{The approximation should be calculated on the dim-dimensional unit cube, defaults to 2.}

\item{depth}{The number of hyperrectangles to be used to devide the unit cube, defaults to 10 for Approximation I and to 32 for Approximation II.}

\item{type}{Whether Approximation I or Approximation II should be used, defaults to one.}

\item{TOL}{A numerical tolerance used when calculating Approximation I.}
}
\value{
\code{GetApprox} returns an object of \code{\link{class}} \sQuote{CopApprox} according to its inputs. The returned object is a list containing a matrix that holds the information of the approximation, the argument \code{Cop}, which approximation was determined, and other auxiliary information.

The only method for objects of class \sQuote{CopApprox} implemented so far are for the generic function \code{\link{plot}}, and then only for the case if \code{dim} was 2.
}
\description{
Approximates the \dQuote{density} of a copula by a piece-wise constant function.
}
\details{
This function provides two methods for subdividing the \eqn{d}-dimensional unit cube into hyper-rectangles, with \eqn{d} being passed to the parameter \code{dim}.  As most of the functions in this package which create a new copula return a function that can be evaluated at points in arbitrary dimensions, it is necessary to specify for which dimension \eqn{d} one wishes to calculate the approximation to the copula's \dQuote{density}.

The first method (Approximation I) determines \eqn{2^m} hyper-rectangles (where \eqn{m} is the parameter \code{depth}), each containing the same probability mass with respect to the copula.  The second method (Approximation II) dividies the unit cube into \eqn{m^d} hyper-squares.

These approximations can be interpreted as piecewise constant approximations of the copula's probability density function if the copula is absolutely continuous.  For futher details see \sQuote{References}.
}
\examples{
Cop <- NewMEVGumbelCopula(3)
CopApprox <- GetApprox(Cop, dim=2)
plot(CopApprox)

}
\references{
Tajvidi, N. and Turlach, B.A. (2018). A general approach to generate random variates for multivariate copulae, \emph{Australian & New Zealand Journal of Statistics} \bold{60}(1): 140--155. \doi{10.1111/anzs.12209}.
}
\seealso{
\code{\link{plot.CopApprox}}
}
\author{
Berwin A. Turlach \email{berwin.turlach@gmail.com}
}
