% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Faces.R
\name{faces}
\alias{faces}
\title{Generate all unique faces of a given dimension from simplices}
\usage{
faces(simplices, target_dim)
}
\arguments{
\item{simplices}{A list of simplices (each a numeric vector).}

\item{target_dim}{The target dimension \eqn{k} for the faces (e.g., \code{0} for vertices, \code{1} for edges, etc.).}
}
\value{
A list of faces (each a numeric vector) of dimension \code{target_dim}.
}
\description{
Generate all unique faces of a given dimension from simplices
}
\details{
The function generates all possible subsets (combinations) of each simplex, removes duplicates,
and filters them to only include those of length \code{target_dim + 1}.

For example, a 2-simplex \code{c(1, 2, 3)} has three 1-dimensional faces (edges):
\code{c(1,2)}, \code{c(1,3)}, and \code{c(2,3)}, and three 0-dimensional faces (vertices):
\code{1}, \code{2}, and \code{3}.
}
\examples{
simplices <- list(c(1, 2), c(3, 4), c(2, 1, 3), c(4, 2))
faces(simplices, target_dim=0)
}
