% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.simple_agree.R
\name{simple_agree-methods}
\alias{simple_agree-methods}
\alias{print.simple_agree}
\alias{plot.simple_agree}
\alias{check}
\alias{check.simple_agree}
\title{Methods for simple_agree objects}
\usage{
\method{print}{simple_agree}(x, ...)

\method{plot}{simple_agree}(
  x,
  type = 1,
  x_name = "x",
  y_name = "y",
  geom = c("geom_point", "geom_bin2d", "geom_density_2d", "geom_density_2d_filled",
    "stat_density_2d"),
  smooth_method = NULL,
  smooth_se = TRUE,
  ...
)

check(x, ...)

\method{check}{simple_agree}(x, ...)
}
\arguments{
\item{x}{object of class \code{simple_agree} as returned from a function starting with 'agree'}

\item{...}{further arguments passed through, see description of return value
for details.
\code{\link{agree_test}}.}

\item{type}{Type of plot to output. Default (1) is Bland-Altman plot while type=2 will produce a line-of-identity plot.}

\item{x_name}{Name/label for x values (first measurement)}

\item{y_name}{Name/label for y values (second measurement)}

\item{geom}{String naming the type of geometry to display the data points. Default is "geom_point". Other options include: "geom_bin2d", "geom_density_2d", "geom_density_2d_filled", and "stat_density_2d".}

\item{smooth_method}{Smoothing method (function) to use, accepts either NULL or a character vector, e.g. "lm", "glm", "gam", "loess" or a function. Default is NULL, which will not include a trend line.}

\item{smooth_se}{Display confidence interval around smooth?}
}
\value{
\describe{
\item{\code{print}}{Prints short summary of the Limits of Agreement}
\item{\code{plot}}{Returns a plot of the limits of agreement (type = 1) or concordance plot (type = 2)}
\item{\code{check}}{Returns 2 plots, p_norm and p_het, testing the assumptions of a Bland-Altman analysis. P-values for the normality and heteroskedasticity tests are provided as captions to the plot.}
}
}
\description{
Methods defined for objects returned from the agree functions.
}
