% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rb.R
\name{rb}
\alias{rb}
\title{rb}
\usage{
rb(
  b_index = NULL,
  method = c("annual", "1over2", "2over3"),
  na.rm = FALSE,
  digits = NULL
)
}
\arguments{
\item{b_index}{Numeric vector of abundance or biomass indices in descending time order (most recent first).}

\item{method}{Character string; one of \code{"annual"} (default), \code{"1over2"}, or \code{"2over3"}.}

\item{na.rm}{Logical; if \code{TRUE}, \code{NA}s are removed before computing.
If \code{FALSE} (default) and \code{NA}s are present in the needed positions, the result may be \code{NA}.}

\item{digits}{Optional integer. If supplied, the result is rounded using
\code{round(x, digits)}. If \code{NULL} (default), full precision is returned.}
}
\value{
A numeric scalar: the proportional rate of change \code{rb}. Positive values
indicate an increase; negative values indicate a decrease.
}
\description{
Calculates the proportional rate of change in an abundance or biomass index (\code{rb})
between consecutive data points using one of three methods:
\describe{
\item{\code{"annual"}}{Change between the two most recent data points:
\eqn{(x_1 - x_2)/x_2}. Requires at least 2 values.}
\item{\code{"1over2"}}{Change between the most recent value and the mean of the
two values prior: \eqn{(x_1 - \bar{x}_{2:3})/\bar{x}_{2:3}}. Requires at least 3 values.}
\item{\code{"2over3"}}{Change between the mean of the two most recent values and
the mean of the three values prior: \eqn{(\bar{x}_{1:2} - \bar{x}_{3:5})/\bar{x}_{3:5}}.
Requires at least 5 values.}
}
}
\details{
Validates that sufficient data are available for the chosen method and guards
against (near-)zero denominators. If a needed denominator is \code{NA} (after
\code{na.rm}) or numerically zero, an error is thrown.
}
\note{
\code{b_index} must be in descending time order (most recent first). Indices
should be non-negative (e.g., CPUE).
}
\examples{
cpue <- c(0.75, 0.70, 1.49, 1.20, 1.10)  # most recent first
rb(b_index = cpue) # annual method by default
rb(b_index = cpue, method = "1over2")
rb(b_index = cpue, method = "2over3")

cpue2 <- c(0.75, NA, 1.49, 1.20, 1.10)
rb(cpue2, method = "1over2", na.rm = TRUE, digits = 2)

}
\seealso{
\code{\link{TBA}}
}
