% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation-simInit.R
\name{doCallSafe}
\alias{doCallSafe}
\title{Memory safe alternative to \code{do.call}}
\usage{
doCallSafe(what, args, quote = FALSE, envir = parent.frame())
}
\arguments{
\item{what}{either a function or a non-empty character string naming the
    function to be called.}

\item{args}{a \emph{list} of arguments to the function call.  The
    \code{names} attribute of \code{args} gives the argument names.}

\item{quote}{a logical value indicating whether to quote the
    arguments.}

\item{envir}{an environment within which to evaluate the call.  This
    will be most useful if \code{what} is a character string and
    the arguments are symbols or quoted expressions.}
}
\value{
Same as \code{do.call}, but without the memory inefficiency.
}
\description{
\code{doCallSafe} is an alternative implementation for \code{do.call} that does not
evaluate the \code{args} prior to running. This means that R does not become unresponsive
when there are large objects in the \code{args}. This should be used \emph{always} instead
of \code{do.call}, whenever there are possibly large objects within the \code{args}. This is
a verbatim copy from package \code{Gmisc} at
\url{https://search.r-project.org/CRAN/refmans/Gmisc/html/fastDoCall.html}
}
