% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unet.R
\name{unet}
\alias{unet}
\title{UNet model for spatial downscaling using deep learning}
\usage{
unet(
  coarse_data,
  fine_data,
  time_points = NULL,
  val_coarse_data = NULL,
  val_fine_data = NULL,
  val_time_points = NULL,
  cyclical_period = NULL,
  cycle_onehot = FALSE,
  cos_sin_transform = FALSE,
  temporal_basis = c(9, 17, 37),
  temporal_layers = c(32, 64, 128),
  temporal_cnn_filters = c(8, 16),
  temporal_cnn_kernel_sizes = list(c(3, 3), c(3, 3)),
  initial_filters = c(16),
  initial_kernel_sizes = list(c(3, 3)),
  filters = c(32, 64, 128),
  kernel_sizes = list(c(3, 3), c(3, 3), c(3, 3)),
  use_batch_norm = FALSE,
  dropout_rate = 0.2,
  activation = "relu",
  final_activation = "linear",
  optimizer = "adam",
  learning_rate = 0.001,
  loss = "mse",
  metrics = c(),
  batch_size = 32,
  epochs = 10,
  start_from_model = NULL,
  validation_split = 0,
  normalize = TRUE,
  callbacks = NULL,
  seed = NULL,
  verbose = 1
)
}
\arguments{
\item{coarse_data}{3D  array. The coarse resolution input data in format
(x, y, time).}

\item{fine_data}{3D array. The fine resolution target data in format
(x, y, time).}

\item{time_points}{Numeric vector. Optional time points corresponding to each time step in the data.}

\item{val_coarse_data}{An optional 3D array of coarse resolution input data in format
(x, y, time).}

\item{val_fine_data}{An optional 3D array of fine resolution target data in format
(x, y, time).}

\item{val_time_points}{An optional numeric vector of length n representing the time points of the validation samples.}

\item{cyclical_period}{Numeric. Optional period for cyclical time encoding (e.g., 365 for yearly seasonality).}

\item{cycle_onehot}{Boolean. If TRUE, a onehot encoded vector of temporal cycles is added as input to temporal module.}

\item{cos_sin_transform}{Logical. Whether to use cosine-sine transformation for time features. Default: FALSE.}

\item{temporal_basis}{A numeric vector specifying the temporal basis functions to use for time encoding (default is c(9, 17, 37)).}

\item{temporal_layers}{A numeric vector specifying the number of units in each dense layer for time encoding (default is c(32, 64, 128)).}

\item{temporal_cnn_filters}{A numeric vector specifying the number of filters in each convolutional layer for temporal feature processing (default is c(8, 16)).}

\item{temporal_cnn_kernel_sizes}{A list of integer vectors specifying the kernel sizes for each convolutional layer in the temporal feature processing (default is list(c(3, 3), c(3, 3))).}

\item{initial_filters}{Integer vector. Number of filters in the initial convolutional layers. Default: c(16).}

\item{initial_kernel_sizes}{List of integer vectors. Kernel sizes for the initial convolutional layers. Default: list(c(3, 3)).}

\item{filters}{Integer vector. Number of filters in each convolutional layer. Default: c(32, 64, 128).}

\item{kernel_sizes}{List of integer vectors. Kernel sizes for each convolutional layer. Default: list(c(3, 3), c(3, 3), c(3, 3)).}

\item{use_batch_norm}{Logical. Whether to use batch normalization after convolutional layers. Default: FALSE.}

\item{dropout_rate}{Numeric. Dropout rate for regularization. Default: 0.2.}

\item{activation}{Character. Activation function for hidden layers. The options are listed in \url{https://keras.io/api/layers/activations}. Default: "relu".}

\item{final_activation}{Character. Activation function for output layer. The options are listed in \url{https://keras.io/api/layers/activations}. Default: "linear".}

\item{optimizer}{Character or optimizer object used in \code{keras3::compile} (see e.g. \link[keras3]{optimizer_adam}). Optimizer for training. The options are listed in \url{https://keras.io/api/optimizers}. Default: "adam".}

\item{learning_rate}{Numeric. Learning rate for optimizer. Default: 0.001.}

\item{loss}{Character or loss function used in \code{keras3::compile} (see \link[keras3]{Loss}). Loss function for training. The options are listed in \url{https://keras.io/api/losses}. Default: "mse".}

\item{metrics}{Optional character vector used in \code{keras3::compile}. Metrics to track during training. The options are listed in \url{https://keras.io/api/metrics}. Default is an empty vector.}

\item{batch_size}{Integer. Batch size for training. Default: 32.}

\item{epochs}{Integer. Number of training epochs. Default: 100.}

\item{start_from_model}{An optional pre-trained Keras model to continue training from (default is NULL).}

\item{validation_split}{Numeric. Fraction of data to use for validation. Default: 0.}

\item{normalize}{Logical. Whether to normalize data before training. Default: TRUE.}

\item{callbacks}{List. Keras callbacks for training (see \link[keras3]{Callback}). Default: NULL.}

\item{seed}{Integer. Random seed for reproducibility. Default: NULL.}

\item{verbose}{Integer. Verbosity mode (0, 1, or 2). Default: 1.}
}
\value{
List containing the trained model and associated components:
\item{model}{Trained Keras model}
\item{input_mask}{Mask for input data based on the missing values}
\item{target_mask}{Mask for target data based on the missing values}
\item{min_time_point}{Minimum time point in the training data}
\item{max_time_point}{Maximum time point in the training data}
\item{cyclical_period}{Cyclical period for time encoding}
\item{max_season}{Maximum season for time encoding}
\item{axis_names}{Names of the axes in the input data}
\item{history}{Training history}
}
\description{
Implements a time-aware UNet convolutional neural network for spatial downscaling of grid data.
Time-aware UNet features an encoder-decoder architecture with skip connections and a temporal module.
The function allows an option for adding a temporal module for spatio-temporal applications.
}
\details{
The UNet architecture \insertCite{ronneberger2015u}{SpatialDownscaling} is widely used in image processing
tasks and has recently been adopted for spatial downscaling applications
\insertCite{sha2020deep}{SpatialDownscaling}. The method implemented here consists of:
\enumerate{
\item \strong{Initial Upscaling} – Coarse-resolution inputs are first upsampled using
bilinear interpolation to match the spatial dimensions of the fine-resolution target.
\item \strong{Initial Feature Extraction} – Multiple convolutional layers extract
low-level features before entering the encoder path.
\item \strong{Encoder Path} – A sequence of convolutional blocks with max-pooling
reduces spatial dimensions while increasing feature depth.
\item \strong{Decoder Path} – Spatial resolution is recovered via bilinear upsampling
and convolutional layers. Skip connections from the encoder help preserve
fine-scale information.
\item \strong{Skip Connections} – These link encoder and decoder layers at matching
resolutions, improving gradient flow and retaining fine spatial structure.
\item \strong{Temporal Module (optional)} – Time information can be incorporated
through cosine–sine encoding, one-hot seasonal encoding, or radial-basis
temporal features. These are passed through dense layers and reshaped to
merge with the UNet bottleneck.
}

The function supports missing data via masking, optional normalization,
validation data, and configurable UNet depth and width.
}
\examples{

\donttest{
 # Create tiny dummy data:
 # Coarse grid: 8x8 → Fine grid: 16x16
 nx_c <- 8
 ny_c <- 8
 nx_f <- 16
 ny_f <- 16
 T <- 5  # number of time steps
 
 # Coarse data:
 coarse_data <- array(runif(nx_c * ny_c * T),
                      dim = c(nx_c, ny_c, T))
 
 # Fine data:
 fine_data <- array(runif(nx_f * ny_f * T),
                    dim = c(nx_f, ny_f, T))
 
 # Optional time points
 time_points <- 1:T
 
 # Fit a tiny UNet (very small filters to keep the example fast)
 model_obj <- unet(
   coarse_data,
   fine_data,
   time_points = time_points,
   filters = c(8, 16),
   initial_filters = c(4),
   epochs = 1,
   batch_size = 4,
   verbose = 0
 )
}
 
}
\references{
\insertAllCited{}
}
