% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freq_by_line.R
\name{freq_by_line}
\alias{freq_by_line}
\title{One-Line Frequency Summary by Treatment Group}
\usage{
freq_by_line(data, id_var, trt_var, filter_expr, label, denom_data = NULL)
}
\arguments{
\item{data}{A data.frame containing subject-level data.}

\item{id_var}{Unquoted subject ID variable (e.g., \code{USUBJID}).}

\item{trt_var}{Unquoted treatment variable (e.g., \code{TRT01P}).}

\item{filter_expr}{A logical filter expression (unquoted),
e.g., \code{SAFFL == "Y" & AGE >= 65}.}

\item{label}{Character string for the row label in the output
(e.g., \code{"SAF population"}).}

\item{denom_data}{Optional. A data.frame used to calculate denominators per
treatment group. Defaults to \code{data}.}
}
\value{
A one-row tibble containing \code{"n (pct)"} summaries per treatment group.
}
\description{
Generates a single-row frequency summary table across treatment groups,
reporting counts and percentages of subjects meeting a filter condition.
}
\details{
This function calculates the number and percentage of unique subjects per
treatment group (\code{trt_var}) satisfying a given filter condition
(\code{filter_expr}). The result is formatted as \code{"n (pct)"} and returned in a
single-row tibble, labeled by the provided \code{label}. An optional denominator
dataset (\code{denom_data}) can be specified to override the default denominator
population (used to calculate percentages).

Useful for producing compact summary rows (e.g., "SAF Population",
"Subjects >= 65") in clinical tables.
}
\examples{
set.seed(123)
adsl <- data.frame(
  USUBJID = paste0("SUBJ", 1:100),
  TRT01P = sample(c("0", "54", "100"), 100, replace = TRUE),
  SAFFL = sample(c("Y", "N"), 100, replace = TRUE),
  AGE = sample(18:80, 100, replace = TRUE)
)


freq_by_line(adsl, USUBJID, TRT01P, SAFFL == "Y", label = "SAF population")


saf <- adsl[adsl$SAFFL == "Y", ]

freq_by_line(
  adsl, USUBJID, TRT01P,
  AGE >= 65,
  label = "Age >=65 in SAF",
  denom_data = saf
)

}
