% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_column_info.R
\name{get_column_info}
\alias{get_column_info}
\title{Extract Column Metadata from a Data Frame}
\usage{
get_column_info(
  df,
  include_attributes = TRUE,
  exclude_attributes = c("class", "row.names"),
  label_attr = c("label", "var.label", "labelled", "Label"),
  format_attr = c("format", "format.sas", "Format", "displayWidth"),
  compute_ranges = TRUE,
  sas_date_display = TRUE
)
}
\arguments{
\item{df}{A data.frame or tibble. The input dataset whose column metadata should be extracted.}

\item{include_attributes}{Logical. If TRUE, includes a list-column of full attributes (after exclusions).}

\item{exclude_attributes}{Character vector of attribute names to drop from the attributes list.}

\item{label_attr}{Character vector of attribute names to check (in order) for a label.}

\item{format_attr}{Character vector of attribute names to check (in order) for a format.}

\item{compute_ranges}{Logical. If TRUE, computes min/max for numeric and date/datetime types.}

\item{sas_date_display}{Logical. If TRUE, adds SAS-style display columns for Date/POSIXct.}
}
\value{
A tibble with one row per column and metadata fields.
\itemize{
\item \strong{column}: Column name
\item \strong{label}: Label attribute (if present)
\item \strong{format}: Format attribute (if present; e.g., DATE9.)
\item \strong{class}: Class(es)
\item \strong{typeof}: Underlying storage type
\item \strong{n}: Total length
\item \strong{n_missing}: Number of NAs
\item \strong{n_unique}: Number of unique values
\item \strong{min_raw/max_raw}: Min/max as raw values (Date/numeric)
\item \strong{min_disp/max_disp}: Min/max as display strings (SAS-like for dates when enabled)
\item \strong{sample_disp}: First non-missing value as display string (SAS-like for dates when enabled)
\item \strong{attribute_names}: Comma-separated attribute names (after exclusions)
\item \strong{attributes}: List column of attributes (optional)
}
}
\description{
Inspects a data frame and returns a summary of metadata for each column,
including column name, label, format, class/type, missingness, uniqueness,
and (optionally) SAS-style display for Date variables (e.g., DATE9 -> 09JUL2012).
}
\examples{

df <- data.frame(
  USUBJID = c("01", "02", "03"),
  AGE     = c(45, 50, NA),
  TRTAN   = c(1L, 2L, 1L),
  ASTDT   = as.Date(c("2024-01-01", "2024-01-02", "2024-01-03")),
  stringsAsFactors = FALSE
)

get_column_info(df)

}
