% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plot_boxplot}
\alias{plot_boxplot}
\title{Create publication-quality box plot}
\usage{
plot_boxplot(data, col, group_col = NULL, add_points = TRUE)
}
\arguments{
\item{data}{A data.frame containing survey data}

\item{col}{Character string specifying column name for numeric variable}

\item{group_col}{Character string specifying column name for grouping variable (optional)}

\item{add_points}{Logical whether to add individual data points (default: TRUE)}
}
\value{
A ggplot object
}
\description{
This function creates a clean, publication-quality box plot for numeric variables,
optionally grouped by a categorical variable.
}
\examples{
data <- data.frame(age = c(25, 30, 35, 40, 45), gender = c("M", "F", "M", "F", "M"))
box_plot <- plot_boxplot(data, "age")
grouped_box <- plot_boxplot(data, "age", "gender")
}
