% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_check_s3.R
\docType{class}
\name{ldmppr_model_check}
\alias{ldmppr_model_check}
\alias{print.ldmppr_model_check}
\alias{summary.ldmppr_model_check}
\alias{print.summary.ldmppr_model_check}
\alias{plot.ldmppr_model_check}
\title{Model fit diagnostic object}
\usage{
\method{print}{ldmppr_model_check}(x, ...)

\method{summary}{ldmppr_model_check}(object, ...)

\method{print}{summary.ldmppr_model_check}(x, ...)

\method{plot}{ldmppr_model_check}(x, which = c("combined", "L", "F", "G", "J", "E", "V"), ...)
}
\arguments{
\item{x}{an object of class \code{ldmppr_model_check}.}

\item{...}{additional arguments passed to the underlying \code{plot()} method (e.g., from **GET**).}

\item{object}{an object of class \code{ldmppr_model_check}.}

\item{which}{which envelope to plot. \code{"combined"} plots the global envelope;
otherwise one of \code{"L"}, \code{"F"}, \code{"G"}, \code{"J"}, \code{"E"}, \code{"V"}.}
}
\value{
\describe{
   \item{\code{print()}}{prints a brief summary of the diagnostic object.}
   \item{\code{summary()}}{returns a \code{summary.ldmppr_model_check} object.}
   \item{\code{plot()}}{plots the combined envelope or a selected statistic envelope.}
}
}
\description{
Objects of class \code{ldmppr_model_check} are returned by \code{\link{check_model_fit}}.
They contain global envelope test results and curve sets for multiple summary
functions/statistics.
}
\details{
An \code{ldmppr_model_check} is a list with components such as:
\itemize{
  \item \code{combined_env}: a global envelope test object (typically from **GET**)
  \item \code{envs}: named list of envelope test objects (e.g., \code{L}, \code{F}, \code{G}, \code{J}, \code{E}, \code{V})
  \item \code{curve_sets}: named list of curve set objects
  \item \code{settings}: list of settings used when generating envelopes (e.g., \code{n_sim}, \code{thinning})
}
}
\section{Methods (by generic)}{
\itemize{
\item \code{print(ldmppr_model_check)}: Print a brief summary of the diagnostic results.

\item \code{summary(ldmppr_model_check)}: Summarize p-values from the combined and individual envelopes.

\item \code{plot(ldmppr_model_check)}: Plot the combined envelope or a selected statistic.

}}
\section{Functions}{
\itemize{
\item \code{print(summary.ldmppr_model_check)}: Print a summary produced by \code{\link{summary.ldmppr_model_check}}.

}}
