% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/homology_diagRips.R
\name{diagRips}
\alias{diagRips}
\title{Compute Vietoris-Rips Complex for Persistent Homology}
\usage{
diagRips(data, maxdim = 1, threshold = Inf)
}
\arguments{
\item{data}{a \code{'matrix'} or a S3 \code{'dist'} object.}

\item{maxdim}{maximum dimension of the computed homological features (default: 1).}

\item{threshold}{maximum value of the filtration (default: \code{Inf}).}
}
\value{
a dataframe object of S3 class \code{"homology"} with following columns\describe{
\item{Dimension}{dimension corresponding to a feature.}
\item{Birth}{birth of a feature.}
\item{Death}{death of a feature.}
}
}
\description{
\code{diagRips} computes the persistent diagram of the Vietoris-Rips filtration 
constructed on a point cloud represented as \code{matrix} or \code{dist} object. 
This function is a second-hand wrapper to \pkg{TDAstats}'s wrapping for \code{Ripser} library.
}
\examples{
# ---------------------------------------------------------------------------
# Check consistency of two types of inputs : 'matrix' and 'dist' objects
# ---------------------------------------------------------------------------
# Use 'iris' data and compute its distance matrix
XX = as.matrix(iris[,1:4])
DX = stats::dist(XX)

# Compute VR Diagram with two inputs
vr.mat = diagRips(XX)
vr.dis = diagRips(DX)

col1 = as.factor(vr.mat$Dimension)
col2 = as.factor(vr.dis$Dimension)

# Visualize
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,2), pty="s")
plot(vr.mat$Birth, vr.mat$Death, pch=19, col=col1, main="from 'matrix'")
plot(vr.dis$Birth, vr.dis$Death, pch=19, col=col2, main="from 'dist'")
par(opar)

}
\references{
\insertRef{wadhwa_tdastats_2018}{TDAkit}

Ulrich Bauer (2019). ``Ripser: Efficient Computation of Vietoris-Rips Persistence Barcodes.'' \emph{arXiv:1908.02518}.
}
\seealso{
\code{\link[TDAstats]{calculate_homology}}
}
\concept{diagram}
