% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{BFI}
\alias{BFI}
\title{Baseflow index (BFI)}
\usage{
BFI(Q, PlotTitle = "Baseflow plot", Plot = TRUE, ReturnData = FALSE)
}
\arguments{
\item{Q}{the daily mean flow series. Numeric vector}

\item{PlotTitle}{the title of the plot. The default is "Baseflow plot"}

\item{Plot}{a logical argument with a default of TRUE. If TRUE the daily flow is plotted with the baseflow highlighted.}

\item{ReturnData}{Logical statement with a default of FALSE. If TRUE, the result is a list with BFI as the first element and the second element is a dataframe with the baseflow and flow data.}
}
\value{
the baseflow index and if Plot equals TRUE, a plot showing the flow time series (black) and the associated baseflow (red). If ReturnData is set to TRUE, the result is a list with two elements. The first is the BFI, the second is a data frame with the flow data and baseflow data.
}
\description{
Calculates the baseflow index from a daily mean flow series
}
\details{
The baseflow index is calculated using the method outlined in Gustard, A. Bullock, A. Dixon, J. M.. (1992). Low flow estimation in the United Kingdom. Wallingford, Institute of Hydrology, 88pp. (IH Report No.108)
}
\examples{
# Calculate the BFI from the daily discharge at Kingston upon Thames,
# which is in column three of the ThamesPQ data
BFI(ThamesPQ[, 3])

}
\author{
Anthony Hammond
}
