% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{DonAdj}
\alias{DonAdj}
\title{Donor adjustment candidates}
\usage{
DonAdj(CDs, N = 10, UrbMax = 1)
}
\arguments{
\item{CDs}{catchment descriptors derived from either GetCDs or CDsXML for the site of interest}

\item{N}{number of sites provided; default is 10}

\item{UrbMax}{a maximum value for URBEXT (the default is 0.03). Any sites with UBEXT2015 above UrbMax will not be included in the results.}
}
\value{
A data.frame with rownames of site references and columns of catchment descriptors and distance from subject site.
}
\description{
Provides donor adjustment candidates, with associated descriptors, in order of the proximity to the centroid of the subject catchment.
}
\details{
This function provides the closest N catchments for consideration for QMED donor adjustment.
}
\examples{
# Get some CDs and output candidate donor sites
cds_54022 <- GetCDs(54022)
DonAdj(cds_54022)



}
\author{
Anthony Hammond
}
